package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ISCSIVolumeSourceFluent<A extends ISCSIVolumeSourceFluent<A>> extends Fluent<A>{
  public Boolean getChapAuthDiscovery();
  public A withChapAuthDiscovery(Boolean chapAuthDiscovery);
  public Boolean hasChapAuthDiscovery();
  public Boolean getChapAuthSession();
  public A withChapAuthSession(Boolean chapAuthSession);
  public Boolean hasChapAuthSession();
  public String getFsType();
  public A withFsType(String fsType);
  public Boolean hasFsType();
  public String getInitiatorName();
  public A withInitiatorName(String initiatorName);
  public Boolean hasInitiatorName();
  public String getIqn();
  public A withIqn(String iqn);
  public Boolean hasIqn();
  public String getIscsiInterface();
  public A withIscsiInterface(String iscsiInterface);
  public Boolean hasIscsiInterface();
  public Integer getLun();
  public A withLun(Integer lun);
  public Boolean hasLun();
  public A addToPortals(int index,String item);
  public A setToPortals(int index,String item);
  public A addToPortals(java.lang.String... items);
  public A addAllToPortals(Collection<String> items);
  public A removeFromPortals(java.lang.String... items);
  public A removeAllFromPortals(Collection<String> items);
  public List<String> getPortals();
  public String getPortal(int index);
  public String getFirstPortal();
  public String getLastPortal();
  public String getMatchingPortal(Predicate<String> predicate);
  public Boolean hasMatchingPortal(Predicate<String> predicate);
  public A withPortals(List<String> portals);
  public A withPortals(java.lang.String... portals);
  public Boolean hasPortals();
  public Boolean getReadOnly();
  public A withReadOnly(Boolean readOnly);
  public Boolean hasReadOnly();
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecretRef();
  public LocalObjectReference buildSecretRef();
  public A withSecretRef(LocalObjectReference secretRef);
  public Boolean hasSecretRef();
  public A withNewSecretRef(String name);
  public ISCSIVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
  public ISCSIVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item);
  public ISCSIVolumeSourceFluent.SecretRefNested<A> editSecretRef();
  public ISCSIVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef();
  public ISCSIVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item);
  public String getTargetPortal();
  public A withTargetPortal(String targetPortal);
  public Boolean hasTargetPortal();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withChapAuthDiscovery();
  public A withChapAuthSession();
  public A withReadOnly();
  public interface SecretRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<ISCSIVolumeSourceFluent.SecretRefNested<N>>{
    public N and();
    public N endSecretRef();
    
  }
  
}