package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GlusterfsPersistentVolumeSourceBuilder extends GlusterfsPersistentVolumeSourceFluentImpl<GlusterfsPersistentVolumeSourceBuilder> implements VisitableBuilder<GlusterfsPersistentVolumeSource,GlusterfsPersistentVolumeSourceBuilder>{
  public GlusterfsPersistentVolumeSourceBuilder() {
    this(false);
  }
  public GlusterfsPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new GlusterfsPersistentVolumeSource(), validationEnabled);
  }
  public GlusterfsPersistentVolumeSourceBuilder(GlusterfsPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GlusterfsPersistentVolumeSourceBuilder(GlusterfsPersistentVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GlusterfsPersistentVolumeSource(), validationEnabled);
  }
  public GlusterfsPersistentVolumeSourceBuilder(GlusterfsPersistentVolumeSourceFluent<?> fluent,GlusterfsPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public GlusterfsPersistentVolumeSourceBuilder(GlusterfsPersistentVolumeSourceFluent<?> fluent,GlusterfsPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEndpoints(instance.getEndpoints());
      fluent.withEndpointsNamespace(instance.getEndpointsNamespace());
      fluent.withPath(instance.getPath());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GlusterfsPersistentVolumeSourceBuilder(GlusterfsPersistentVolumeSource instance) {
    this(instance,false);
  }
  public GlusterfsPersistentVolumeSourceBuilder(GlusterfsPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEndpoints(instance.getEndpoints());
      this.withEndpointsNamespace(instance.getEndpointsNamespace());
      this.withPath(instance.getPath());
      this.withReadOnly(instance.getReadOnly());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GlusterfsPersistentVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public GlusterfsPersistentVolumeSource build() {
    GlusterfsPersistentVolumeSource buildable = new GlusterfsPersistentVolumeSource(fluent.getEndpoints(),fluent.getEndpointsNamespace(),fluent.getPath(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}