package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GenericKubernetesResourceBuilder extends GenericKubernetesResourceFluentImpl<GenericKubernetesResourceBuilder> implements VisitableBuilder<GenericKubernetesResource,GenericKubernetesResourceBuilder>{
  public GenericKubernetesResourceBuilder() {
    this(false);
  }
  public GenericKubernetesResourceBuilder(Boolean validationEnabled) {
    this(new GenericKubernetesResource(), validationEnabled);
  }
  public GenericKubernetesResourceBuilder(GenericKubernetesResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GenericKubernetesResourceBuilder(GenericKubernetesResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GenericKubernetesResource(), validationEnabled);
  }
  public GenericKubernetesResourceBuilder(GenericKubernetesResourceFluent<?> fluent,GenericKubernetesResource instance) {
    this(fluent, instance, false);
  }
  public GenericKubernetesResourceBuilder(GenericKubernetesResourceFluent<?> fluent,GenericKubernetesResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GenericKubernetesResourceBuilder(GenericKubernetesResource instance) {
    this(instance,false);
  }
  public GenericKubernetesResourceBuilder(GenericKubernetesResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GenericKubernetesResourceFluent<?> fluent;
  Boolean validationEnabled;
  public GenericKubernetesResource build() {
    GenericKubernetesResource buildable = new GenericKubernetesResource();
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}