package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodResourceClaimFluentImpl<A extends PodResourceClaimFluent<A>> extends BaseFluent<A> implements PodResourceClaimFluent<A>{
  public PodResourceClaimFluentImpl() {
  }
  public PodResourceClaimFluentImpl(PodResourceClaim instance) {
    this.withName(instance.getName()); 
    this.withSource(instance.getSource()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String name;
  private ClaimSourceBuilder source;
  private Map<String,Object> additionalProperties;
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClaimSource getSource() {
    return this.source!=null ?this.source.build():null;
  }
  public ClaimSource buildSource() {
    return this.source!=null ?this.source.build():null;
  }
  public A withSource(ClaimSource source) {
    _visitables.get("source").remove(this.source);
    if (source!=null){ this.source= new ClaimSourceBuilder(source); _visitables.get("source").add(this.source);} else { this.source = null; _visitables.get("source").remove(this.source); } return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public A withNewSource(String resourceClaimName,String resourceClaimTemplateName) {
    return (A)withSource(new ClaimSource(resourceClaimName, resourceClaimTemplateName));
  }
  public PodResourceClaimFluent.SourceNested<A> withNewSource() {
    return new PodResourceClaimFluentImpl.SourceNestedImpl();
  }
  public PodResourceClaimFluent.SourceNested<A> withNewSourceLike(ClaimSource item) {
    return new PodResourceClaimFluentImpl.SourceNestedImpl(item);
  }
  public PodResourceClaimFluent.SourceNested<A> editSource() {
    return withNewSourceLike(getSource());
  }
  public PodResourceClaimFluent.SourceNested<A> editOrNewSource() {
    return withNewSourceLike(getSource() != null ? getSource(): new ClaimSourceBuilder().build());
  }
  public PodResourceClaimFluent.SourceNested<A> editOrNewSourceLike(ClaimSource item) {
    return withNewSourceLike(getSource() != null ? getSource(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodResourceClaimFluentImpl that = (PodResourceClaimFluentImpl) o;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (source != null ? !source.equals(that.source) :that.source != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(name,  source,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SourceNestedImpl<N> extends ClaimSourceFluentImpl<PodResourceClaimFluent.SourceNested<N>> implements PodResourceClaimFluent.SourceNested<N>,Nested<N>{
    SourceNestedImpl(ClaimSource item) {
      this.builder = new ClaimSourceBuilder(this, item);
    }
    SourceNestedImpl() {
      this.builder = new ClaimSourceBuilder(this);
    }
    ClaimSourceBuilder builder;
    public N and() {
      return (N) PodResourceClaimFluentImpl.this.withSource(builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  
}