package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EndpointSubsetFluentImpl<A extends EndpointSubsetFluent<A>> extends BaseFluent<A> implements EndpointSubsetFluent<A>{
  public EndpointSubsetFluentImpl() {
  }
  public EndpointSubsetFluentImpl(EndpointSubset instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withNotReadyAddresses(instance.getNotReadyAddresses()); 
    this.withPorts(instance.getPorts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<EndpointAddressBuilder> addresses = new ArrayList<EndpointAddressBuilder>();
  private ArrayList<EndpointAddressBuilder> notReadyAddresses = new ArrayList<EndpointAddressBuilder>();
  private ArrayList<EndpointPortBuilder> ports = new ArrayList<EndpointPortBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToAddresses(Integer index,EndpointAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<EndpointAddressBuilder>();}
    EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("addresses").add(index >= 0 ? index : _visitables.get("addresses").size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
  }
  public A setToAddresses(Integer index,EndpointAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<EndpointAddressBuilder>();}
    EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
    if (index < 0 || index >= _visitables.get("addresses").size()) { _visitables.get("addresses").add(builder); } else { _visitables.get("addresses").set(index, builder);}
    if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
     return (A)this;
  }
  public A addToAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<EndpointAddressBuilder>();}
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A addAllToAddresses(Collection<EndpointAddress> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<EndpointAddressBuilder>();}
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeAllFromAddresses(Collection<EndpointAddress> items) {
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAddresses(Predicate<EndpointAddressBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<EndpointAddressBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      EndpointAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAddresses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EndpointAddress> getAddresses() {
    return addresses != null ? build(addresses) : null;
  }
  public List<EndpointAddress> buildAddresses() {
    return addresses != null ? build(addresses) : null;
  }
  public EndpointAddress buildAddress(Integer index) {
    return this.addresses.get(index).build();
  }
  public EndpointAddress buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  public EndpointAddress buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  public EndpointAddress buildMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
    for (EndpointAddressBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
    for (EndpointAddressBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(List<EndpointAddress> addresses) {
    if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
    if (addresses != null) {this.addresses = new ArrayList(); for (EndpointAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (EndpointAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public EndpointSubsetFluent.AddressesNested<A> addNewAddress() {
    return new EndpointSubsetFluentImpl.AddressesNestedImpl();
  }
  public EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(EndpointAddress item) {
    return new EndpointSubsetFluentImpl.AddressesNestedImpl(-1, item);
  }
  public EndpointSubsetFluent.AddressesNested<A> setNewAddressLike(Integer index,EndpointAddress item) {
    return new EndpointSubsetFluentImpl.AddressesNestedImpl(index, item);
  }
  public EndpointSubsetFluent.AddressesNested<A> editAddress(Integer index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public EndpointSubsetFluent.AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  public EndpointSubsetFluent.AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public EndpointSubsetFluent.AddressesNested<A> editMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public A addToNotReadyAddresses(Integer index,EndpointAddress item) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();}
    EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").add(index >= 0 ? index : _visitables.get("notReadyAddresses").size(), builder);this.notReadyAddresses.add(index >= 0 ? index : notReadyAddresses.size(), builder); return (A)this;
  }
  public A setToNotReadyAddresses(Integer index,EndpointAddress item) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();}
    EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
    if (index < 0 || index >= _visitables.get("notReadyAddresses").size()) { _visitables.get("notReadyAddresses").add(builder); } else { _visitables.get("notReadyAddresses").set(index, builder);}
    if (index < 0 || index >= notReadyAddresses.size()) { notReadyAddresses.add(builder); } else { notReadyAddresses.set(index, builder);}
     return (A)this;
  }
  public A addToNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();}
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").add(builder);this.notReadyAddresses.add(builder);} return (A)this;
  }
  public A addAllToNotReadyAddresses(Collection<EndpointAddress> items) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();}
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").add(builder);this.notReadyAddresses.add(builder);} return (A)this;
  }
  public A removeFromNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").remove(builder);if (this.notReadyAddresses != null) {this.notReadyAddresses.remove(builder);}} return (A)this;
  }
  public A removeAllFromNotReadyAddresses(Collection<EndpointAddress> items) {
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").remove(builder);if (this.notReadyAddresses != null) {this.notReadyAddresses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNotReadyAddresses(Predicate<EndpointAddressBuilder> predicate) {
    if (notReadyAddresses == null) return (A) this;
    final Iterator<EndpointAddressBuilder> each = notReadyAddresses.iterator();
    final List visitables = _visitables.get("notReadyAddresses");
    while (each.hasNext()) {
      EndpointAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildNotReadyAddresses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EndpointAddress> getNotReadyAddresses() {
    return notReadyAddresses != null ? build(notReadyAddresses) : null;
  }
  public List<EndpointAddress> buildNotReadyAddresses() {
    return notReadyAddresses != null ? build(notReadyAddresses) : null;
  }
  public EndpointAddress buildNotReadyAddress(Integer index) {
    return this.notReadyAddresses.get(index).build();
  }
  public EndpointAddress buildFirstNotReadyAddress() {
    return this.notReadyAddresses.get(0).build();
  }
  public EndpointAddress buildLastNotReadyAddress() {
    return this.notReadyAddresses.get(notReadyAddresses.size() - 1).build();
  }
  public EndpointAddress buildMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
    for (EndpointAddressBuilder item: notReadyAddresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
    for (EndpointAddressBuilder item: notReadyAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses) {
    if (this.notReadyAddresses != null) { _visitables.get("notReadyAddresses").removeAll(this.notReadyAddresses);}
    if (notReadyAddresses != null) {this.notReadyAddresses = new ArrayList(); for (EndpointAddress item : notReadyAddresses){this.addToNotReadyAddresses(item);}} else { this.notReadyAddresses = null;} return (A) this;
  }
  public A withNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... notReadyAddresses) {
    if (this.notReadyAddresses != null) {this.notReadyAddresses.clear();}
    if (notReadyAddresses != null) {for (EndpointAddress item :notReadyAddresses){ this.addToNotReadyAddresses(item);}} return (A) this;
  }
  public Boolean hasNotReadyAddresses() {
    return notReadyAddresses != null && !notReadyAddresses.isEmpty();
  }
  public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress() {
    return new EndpointSubsetFluentImpl.NotReadyAddressesNestedImpl();
  }
  public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item) {
    return new EndpointSubsetFluentImpl.NotReadyAddressesNestedImpl(-1, item);
  }
  public EndpointSubsetFluent.NotReadyAddressesNested<A> setNewNotReadyAddressLike(Integer index,EndpointAddress item) {
    return new EndpointSubsetFluentImpl.NotReadyAddressesNestedImpl(index, item);
  }
  public EndpointSubsetFluent.NotReadyAddressesNested<A> editNotReadyAddress(Integer index) {
    if (notReadyAddresses.size() <= index) throw new RuntimeException("Can't edit notReadyAddresses. Index exceeds size.");
    return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
  }
  public EndpointSubsetFluent.NotReadyAddressesNested<A> editFirstNotReadyAddress() {
    if (notReadyAddresses.size() == 0) throw new RuntimeException("Can't edit first notReadyAddresses. The list is empty.");
    return setNewNotReadyAddressLike(0, buildNotReadyAddress(0));
  }
  public EndpointSubsetFluent.NotReadyAddressesNested<A> editLastNotReadyAddress() {
    int index = notReadyAddresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last notReadyAddresses. The list is empty.");
    return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
  }
  public EndpointSubsetFluent.NotReadyAddressesNested<A> editMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<notReadyAddresses.size();i++) { 
    if (predicate.test(notReadyAddresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching notReadyAddresses. No match found.");
    return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
  }
  public A addToPorts(Integer index,EndpointPort item) {
    if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
    EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
  }
  public A setToPorts(Integer index,EndpointPort item) {
    if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
    EndpointPortBuilder builder = new EndpointPortBuilder(item);
    if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
    if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
     return (A)this;
  }
  public A addToPorts(io.fabric8.kubernetes.api.model.EndpointPort... items) {
    if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(Collection<EndpointPort> items) {
    if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.kubernetes.api.model.EndpointPort... items) {
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeAllFromPorts(Collection<EndpointPort> items) {
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPorts(Predicate<EndpointPortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<EndpointPortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      EndpointPortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EndpointPort> getPorts() {
    return ports != null ? build(ports) : null;
  }
  public List<EndpointPort> buildPorts() {
    return ports != null ? build(ports) : null;
  }
  public EndpointPort buildPort(Integer index) {
    return this.ports.get(index).build();
  }
  public EndpointPort buildFirstPort() {
    return this.ports.get(0).build();
  }
  public EndpointPort buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public EndpointPort buildMatchingPort(Predicate<EndpointPortBuilder> predicate) {
    for (EndpointPortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPort(Predicate<EndpointPortBuilder> predicate) {
    for (EndpointPortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(List<EndpointPort> ports) {
    if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
    if (ports != null) {this.ports = new ArrayList(); for (EndpointPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.kubernetes.api.model.EndpointPort... ports) {
    if (this.ports != null) {this.ports.clear();}
    if (ports != null) {for (EndpointPort item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public Boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public A addNewPort(String appProtocol,String name,Integer port,String protocol) {
    return (A)addToPorts(new EndpointPort(appProtocol, name, port, protocol));
  }
  public EndpointSubsetFluent.PortsNested<A> addNewPort() {
    return new EndpointSubsetFluentImpl.PortsNestedImpl();
  }
  public EndpointSubsetFluent.PortsNested<A> addNewPortLike(EndpointPort item) {
    return new EndpointSubsetFluentImpl.PortsNestedImpl(-1, item);
  }
  public EndpointSubsetFluent.PortsNested<A> setNewPortLike(Integer index,EndpointPort item) {
    return new EndpointSubsetFluentImpl.PortsNestedImpl(index, item);
  }
  public EndpointSubsetFluent.PortsNested<A> editPort(Integer index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public EndpointSubsetFluent.PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public EndpointSubsetFluent.PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public EndpointSubsetFluent.PortsNested<A> editMatchingPort(Predicate<EndpointPortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointSubsetFluentImpl that = (EndpointSubsetFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (notReadyAddresses != null ? !notReadyAddresses.equals(that.notReadyAddresses) :that.notReadyAddresses != null) return false;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  notReadyAddresses,  ports,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (notReadyAddresses != null && !notReadyAddresses.isEmpty()) { sb.append("notReadyAddresses:"); sb.append(notReadyAddresses + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AddressesNestedImpl<N> extends EndpointAddressFluentImpl<EndpointSubsetFluent.AddressesNested<N>> implements EndpointSubsetFluent.AddressesNested<N>,Nested<N>{
    AddressesNestedImpl(Integer index,EndpointAddress item) {
      this.index = index;
      this.builder = new EndpointAddressBuilder(this, item);
    }
    AddressesNestedImpl() {
      this.index = -1;
      this.builder = new EndpointAddressBuilder(this);
    }
    EndpointAddressBuilder builder;
    Integer index;
    public N and() {
      return (N) EndpointSubsetFluentImpl.this.setToAddresses(index,builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  class NotReadyAddressesNestedImpl<N> extends EndpointAddressFluentImpl<EndpointSubsetFluent.NotReadyAddressesNested<N>> implements EndpointSubsetFluent.NotReadyAddressesNested<N>,Nested<N>{
    NotReadyAddressesNestedImpl(Integer index,EndpointAddress item) {
      this.index = index;
      this.builder = new EndpointAddressBuilder(this, item);
    }
    NotReadyAddressesNestedImpl() {
      this.index = -1;
      this.builder = new EndpointAddressBuilder(this);
    }
    EndpointAddressBuilder builder;
    Integer index;
    public N and() {
      return (N) EndpointSubsetFluentImpl.this.setToNotReadyAddresses(index,builder.build());
    }
    public N endNotReadyAddress() {
      return and();
    }
    
  }
  class PortsNestedImpl<N> extends EndpointPortFluentImpl<EndpointSubsetFluent.PortsNested<N>> implements EndpointSubsetFluent.PortsNested<N>,Nested<N>{
    PortsNestedImpl(Integer index,EndpointPort item) {
      this.index = index;
      this.builder = new EndpointPortBuilder(this, item);
    }
    PortsNestedImpl() {
      this.index = -1;
      this.builder = new EndpointPortBuilder(this);
    }
    EndpointPortBuilder builder;
    Integer index;
    public N and() {
      return (N) EndpointSubsetFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}