package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapProjectionBuilder extends ConfigMapProjectionFluentImpl<ConfigMapProjectionBuilder> implements VisitableBuilder<ConfigMapProjection,ConfigMapProjectionBuilder>{
  public ConfigMapProjectionBuilder() {
    this(false);
  }
  public ConfigMapProjectionBuilder(Boolean validationEnabled) {
    this(new ConfigMapProjection(), validationEnabled);
  }
  public ConfigMapProjectionBuilder(ConfigMapProjectionFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapProjectionBuilder(ConfigMapProjectionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapProjection(), validationEnabled);
  }
  public ConfigMapProjectionBuilder(ConfigMapProjectionFluent<?> fluent,ConfigMapProjection instance) {
    this(fluent, instance, false);
  }
  public ConfigMapProjectionBuilder(ConfigMapProjectionFluent<?> fluent,ConfigMapProjection instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withItems(instance.getItems()); 
    fluent.withName(instance.getName()); 
    fluent.withOptional(instance.getOptional()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapProjectionBuilder(ConfigMapProjection instance) {
    this(instance,false);
  }
  public ConfigMapProjectionBuilder(ConfigMapProjection instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withItems(instance.getItems()); 
    this.withName(instance.getName()); 
    this.withOptional(instance.getOptional()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConfigMapProjectionFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapProjection build() {
    ConfigMapProjection buildable = new ConfigMapProjection(fluent.getItems(),fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}