package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ConfigMapListFluent<A extends ConfigMapListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,ConfigMap item);
  public A setToItems(Integer index,ConfigMap item);
  public A addToItems(io.fabric8.kubernetes.api.model.ConfigMap... items);
  public A addAllToItems(Collection<ConfigMap> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.ConfigMap... items);
  public A removeAllFromItems(Collection<ConfigMap> items);
  public A removeMatchingFromItems(Predicate<ConfigMapBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConfigMap> getItems();
  public List<ConfigMap> buildItems();
  public ConfigMap buildItem(Integer index);
  public ConfigMap buildFirstItem();
  public ConfigMap buildLastItem();
  public ConfigMap buildMatchingItem(Predicate<ConfigMapBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ConfigMapBuilder> predicate);
  public A withItems(List<ConfigMap> items);
  public A withItems(io.fabric8.kubernetes.api.model.ConfigMap... items);
  public Boolean hasItems();
  public ConfigMapListFluent.ItemsNested<A> addNewItem();
  public ConfigMapListFluent.ItemsNested<A> addNewItemLike(ConfigMap item);
  public ConfigMapListFluent.ItemsNested<A> setNewItemLike(Integer index,ConfigMap item);
  public ConfigMapListFluent.ItemsNested<A> editItem(Integer index);
  public ConfigMapListFluent.ItemsNested<A> editFirstItem();
  public ConfigMapListFluent.ItemsNested<A> editLastItem();
  public ConfigMapListFluent.ItemsNested<A> editMatchingItem(Predicate<ConfigMapBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public ConfigMapListFluent.MetadataNested<A> withNewMetadata();
  public ConfigMapListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public ConfigMapListFluent.MetadataNested<A> editMetadata();
  public ConfigMapListFluent.MetadataNested<A> editOrNewMetadata();
  public ConfigMapListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ConfigMapFluent<ConfigMapListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ConfigMapListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}