package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ReplicationControllerSpecFluentImpl<A extends ReplicationControllerSpecFluent<A>> extends BaseFluent<A> implements ReplicationControllerSpecFluent<A>{
  public ReplicationControllerSpecFluentImpl() {
  }
  public ReplicationControllerSpecFluentImpl(ReplicationControllerSpec instance) {
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withReplicas(instance.getReplicas()); 
    this.withSelector(instance.getSelector()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer minReadySeconds;
  private Integer replicas;
  private Map<String,String> selector;
  private PodTemplateSpecBuilder template;
  private Map<String,Object> additionalProperties;
  public Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  public A withMinReadySeconds(Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  public Boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToSelector(String key,String value) {
    if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap(); }
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
  }
  public A addToSelector(Map<String,String> map) {
    if(this.selector == null && map != null) { this.selector = new LinkedHashMap(); }
    if(map != null) { this.selector.putAll(map);} return (A)this;
  }
  public A removeFromSelector(String key) {
    if(this.selector == null) { return (A) this; }
    if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
  }
  public A removeFromSelector(Map<String,String> map) {
    if(this.selector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSelector() {
    return this.selector;
  }
  public <K,V>A withSelector(Map<String,String> selector) {
    if (selector == null) { this.selector =  null;} else {this.selector = new LinkedHashMap(selector);} return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodTemplateSpec getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public PodTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public Boolean hasTemplate() {
    return this.template != null;
  }
  public ReplicationControllerSpecFluent.TemplateNested<A> withNewTemplate() {
    return new ReplicationControllerSpecFluentImpl.TemplateNestedImpl();
  }
  public ReplicationControllerSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
    return new ReplicationControllerSpecFluentImpl.TemplateNestedImpl(item);
  }
  public ReplicationControllerSpecFluent.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public ReplicationControllerSpecFluent.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
  }
  public ReplicationControllerSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReplicationControllerSpecFluentImpl that = (ReplicationControllerSpecFluentImpl) o;
    if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minReadySeconds,  replicas,  selector,  template,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (selector != null && !selector.isEmpty()) { sb.append("selector:"); sb.append(selector + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<ReplicationControllerSpecFluent.TemplateNested<N>> implements ReplicationControllerSpecFluent.TemplateNested<N>,Nested<N>{
    TemplateNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) ReplicationControllerSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}