package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface PodDNSConfigFluent<A extends PodDNSConfigFluent<A>> extends Fluent<A>{
  public A addToNameservers(Integer index,String item);
  public A setToNameservers(Integer index,String item);
  public A addToNameservers(java.lang.String... items);
  public A addAllToNameservers(Collection<String> items);
  public A removeFromNameservers(java.lang.String... items);
  public A removeAllFromNameservers(Collection<String> items);
  public List<String> getNameservers();
  public String getNameserver(Integer index);
  public String getFirstNameserver();
  public String getLastNameserver();
  public String getMatchingNameserver(Predicate<String> predicate);
  public Boolean hasMatchingNameserver(Predicate<String> predicate);
  public A withNameservers(List<String> nameservers);
  public A withNameservers(java.lang.String... nameservers);
  public Boolean hasNameservers();
  public A addToOptions(Integer index,PodDNSConfigOption item);
  public A setToOptions(Integer index,PodDNSConfigOption item);
  public A addToOptions(io.fabric8.kubernetes.api.model.PodDNSConfigOption... items);
  public A addAllToOptions(Collection<PodDNSConfigOption> items);
  public A removeFromOptions(io.fabric8.kubernetes.api.model.PodDNSConfigOption... items);
  public A removeAllFromOptions(Collection<PodDNSConfigOption> items);
  public A removeMatchingFromOptions(Predicate<PodDNSConfigOptionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodDNSConfigOption> getOptions();
  public List<PodDNSConfigOption> buildOptions();
  public PodDNSConfigOption buildOption(Integer index);
  public PodDNSConfigOption buildFirstOption();
  public PodDNSConfigOption buildLastOption();
  public PodDNSConfigOption buildMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate);
  public Boolean hasMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate);
  public A withOptions(List<PodDNSConfigOption> options);
  public A withOptions(io.fabric8.kubernetes.api.model.PodDNSConfigOption... options);
  public Boolean hasOptions();
  public A addNewOption(String name,String value);
  public PodDNSConfigFluent.OptionsNested<A> addNewOption();
  public PodDNSConfigFluent.OptionsNested<A> addNewOptionLike(PodDNSConfigOption item);
  public PodDNSConfigFluent.OptionsNested<A> setNewOptionLike(Integer index,PodDNSConfigOption item);
  public PodDNSConfigFluent.OptionsNested<A> editOption(Integer index);
  public PodDNSConfigFluent.OptionsNested<A> editFirstOption();
  public PodDNSConfigFluent.OptionsNested<A> editLastOption();
  public PodDNSConfigFluent.OptionsNested<A> editMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate);
  public A addToSearches(Integer index,String item);
  public A setToSearches(Integer index,String item);
  public A addToSearches(java.lang.String... items);
  public A addAllToSearches(Collection<String> items);
  public A removeFromSearches(java.lang.String... items);
  public A removeAllFromSearches(Collection<String> items);
  public List<String> getSearches();
  public String getSearch(Integer index);
  public String getFirstSearch();
  public String getLastSearch();
  public String getMatchingSearch(Predicate<String> predicate);
  public Boolean hasMatchingSearch(Predicate<String> predicate);
  public A withSearches(List<String> searches);
  public A withSearches(java.lang.String... searches);
  public Boolean hasSearches();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface OptionsNested<N> extends Nested<N>,PodDNSConfigOptionFluent<PodDNSConfigFluent.OptionsNested<N>>{
    public N and();
    public N endOption();
    
  }
  
}