package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface NodeListFluent<A extends NodeListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,Node item);
  public A setToItems(Integer index,Node item);
  public A addToItems(io.fabric8.kubernetes.api.model.Node... items);
  public A addAllToItems(Collection<Node> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.Node... items);
  public A removeAllFromItems(Collection<Node> items);
  public A removeMatchingFromItems(Predicate<NodeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Node> getItems();
  public List<Node> buildItems();
  public Node buildItem(Integer index);
  public Node buildFirstItem();
  public Node buildLastItem();
  public Node buildMatchingItem(Predicate<NodeBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<NodeBuilder> predicate);
  public A withItems(List<Node> items);
  public A withItems(io.fabric8.kubernetes.api.model.Node... items);
  public Boolean hasItems();
  public NodeListFluent.ItemsNested<A> addNewItem();
  public NodeListFluent.ItemsNested<A> addNewItemLike(Node item);
  public NodeListFluent.ItemsNested<A> setNewItemLike(Integer index,Node item);
  public NodeListFluent.ItemsNested<A> editItem(Integer index);
  public NodeListFluent.ItemsNested<A> editFirstItem();
  public NodeListFluent.ItemsNested<A> editLastItem();
  public NodeListFluent.ItemsNested<A> editMatchingItem(Predicate<NodeBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public NodeListFluent.MetadataNested<A> withNewMetadata();
  public NodeListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public NodeListFluent.MetadataNested<A> editMetadata();
  public NodeListFluent.MetadataNested<A> editOrNewMetadata();
  public NodeListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,NodeFluent<NodeListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<NodeListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}