package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FCVolumeSourceBuilder extends FCVolumeSourceFluentImpl<FCVolumeSourceBuilder> implements VisitableBuilder<FCVolumeSource,FCVolumeSourceBuilder>{
  public FCVolumeSourceBuilder() {
    this(false);
  }
  public FCVolumeSourceBuilder(Boolean validationEnabled) {
    this(new FCVolumeSource(), validationEnabled);
  }
  public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FCVolumeSource(), validationEnabled);
  }
  public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent,FCVolumeSource instance) {
    this(fluent, instance, false);
  }
  public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent,FCVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsType(instance.getFsType()); 
    fluent.withLun(instance.getLun()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withTargetWWNs(instance.getTargetWWNs()); 
    fluent.withWwids(instance.getWwids()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FCVolumeSourceBuilder(FCVolumeSource instance) {
    this(instance,false);
  }
  public FCVolumeSourceBuilder(FCVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsType(instance.getFsType()); 
    this.withLun(instance.getLun()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withTargetWWNs(instance.getTargetWWNs()); 
    this.withWwids(instance.getWwids()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  FCVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public FCVolumeSource build() {
    FCVolumeSource buildable = new FCVolumeSource(fluent.getFsType(),fluent.getLun(),fluent.getReadOnly(),fluent.getTargetWWNs(),fluent.getWwids());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}