package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeProjectionBuilder extends VolumeProjectionFluentImpl<VolumeProjectionBuilder> implements VisitableBuilder<VolumeProjection,VolumeProjectionBuilder>{
  public VolumeProjectionBuilder() {
    this(false);
  }
  public VolumeProjectionBuilder(Boolean validationEnabled) {
    this(new VolumeProjection(), validationEnabled);
  }
  public VolumeProjectionBuilder(VolumeProjectionFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeProjectionBuilder(VolumeProjectionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeProjection(), validationEnabled);
  }
  public VolumeProjectionBuilder(VolumeProjectionFluent<?> fluent,VolumeProjection instance) {
    this(fluent, instance, false);
  }
  public VolumeProjectionBuilder(VolumeProjectionFluent<?> fluent,VolumeProjection instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMap(instance.getConfigMap()); 
    fluent.withDownwardAPI(instance.getDownwardAPI()); 
    fluent.withSecret(instance.getSecret()); 
    fluent.withServiceAccountToken(instance.getServiceAccountToken()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VolumeProjectionBuilder(VolumeProjection instance) {
    this(instance,false);
  }
  public VolumeProjectionBuilder(VolumeProjection instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMap(instance.getConfigMap()); 
    this.withDownwardAPI(instance.getDownwardAPI()); 
    this.withSecret(instance.getSecret()); 
    this.withServiceAccountToken(instance.getServiceAccountToken()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  VolumeProjectionFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeProjection build() {
    VolumeProjection buildable = new VolumeProjection(fluent.getConfigMap(),fluent.getDownwardAPI(),fluent.getSecret(),fluent.getServiceAccountToken());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}