package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectReferenceBuilder extends ObjectReferenceFluentImpl<ObjectReferenceBuilder> implements VisitableBuilder<ObjectReference,ObjectReferenceBuilder>{
  public ObjectReferenceBuilder() {
    this(false);
  }
  public ObjectReferenceBuilder(Boolean validationEnabled) {
    this(new ObjectReference(), validationEnabled);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObjectReference(), validationEnabled);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent,ObjectReference instance) {
    this(fluent, instance, false);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent,ObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withFieldPath(instance.getFieldPath()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withResourceVersion(instance.getResourceVersion()); 
    fluent.withUid(instance.getUid()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ObjectReferenceBuilder(ObjectReference instance) {
    this(instance,false);
  }
  public ObjectReferenceBuilder(ObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withFieldPath(instance.getFieldPath()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withResourceVersion(instance.getResourceVersion()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ObjectReference build() {
    ObjectReference buildable = new ObjectReference(fluent.getApiVersion(),fluent.getFieldPath(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getResourceVersion(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}