package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GetOptionsBuilder extends GetOptionsFluentImpl<GetOptionsBuilder> implements VisitableBuilder<GetOptions,GetOptionsBuilder>{
  public GetOptionsBuilder() {
    this(false);
  }
  public GetOptionsBuilder(Boolean validationEnabled) {
    this(new GetOptions(), validationEnabled);
  }
  public GetOptionsBuilder(GetOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public GetOptionsBuilder(GetOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GetOptions(), validationEnabled);
  }
  public GetOptionsBuilder(GetOptionsFluent<?> fluent,GetOptions instance) {
    this(fluent, instance, false);
  }
  public GetOptionsBuilder(GetOptionsFluent<?> fluent,GetOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withResourceVersion(instance.getResourceVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GetOptionsBuilder(GetOptions instance) {
    this(instance,false);
  }
  public GetOptionsBuilder(GetOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withResourceVersion(instance.getResourceVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GetOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public GetOptions build() {
    GetOptions buildable = new GetOptions(fluent.getApiVersion(),fluent.getKind(),fluent.getResourceVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}