package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ExecConfigFluentImpl<A extends ExecConfigFluent<A>> extends BaseFluent<A> implements ExecConfigFluent<A>{
  public ExecConfigFluentImpl() {
  }
  public ExecConfigFluentImpl(ExecConfig instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withArgs(instance.getArgs()); 
    this.withCommand(instance.getCommand()); 
    this.withEnv(instance.getEnv()); 
    this.withInstallHint(instance.getInstallHint()); 
    this.withInteractiveMode(instance.getInteractiveMode()); 
    this.withProvideClusterInfo(instance.getProvideClusterInfo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private List<String> args = new ArrayList<String>();
  private String command;
  private ArrayList<ExecEnvVarBuilder> env = new ArrayList<ExecEnvVarBuilder>();
  private String installHint;
  private String interactiveMode;
  private Boolean provideClusterInfo;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToArgs(Integer index,String item) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    this.args.add(index, item);
    return (A)this;
  }
  public A setToArgs(Integer index,String item) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    this.args.set(index, item); return (A)this;
  }
  public A addToArgs(java.lang.String... items) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    for (String item : items) {this.args.add(item);} return (A)this;
  }
  public A addAllToArgs(Collection<String> items) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    for (String item : items) {this.args.add(item);} return (A)this;
  }
  public A removeFromArgs(java.lang.String... items) {
    for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
  }
  public A removeAllFromArgs(Collection<String> items) {
    for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
  }
  public List<String> getArgs() {
    return this.args;
  }
  public String getArg(Integer index) {
    return this.args.get(index);
  }
  public String getFirstArg() {
    return this.args.get(0);
  }
  public String getLastArg() {
    return this.args.get(args.size() - 1);
  }
  public String getMatchingArg(Predicate<String> predicate) {
    for (String item: args) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingArg(Predicate<String> predicate) {
    for (String item: args) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withArgs(List<String> args) {
    if (args != null) {this.args = new ArrayList(); for (String item : args){this.addToArgs(item);}} else { this.args = null;} return (A) this;
  }
  public A withArgs(java.lang.String... args) {
    if (this.args != null) {this.args.clear();}
    if (args != null) {for (String item :args){ this.addToArgs(item);}} return (A) this;
  }
  public Boolean hasArgs() {
    return args != null && !args.isEmpty();
  }
  public String getCommand() {
    return this.command;
  }
  public A withCommand(String command) {
    this.command=command; return (A) this;
  }
  public Boolean hasCommand() {
    return this.command != null;
  }
  public A addToEnv(Integer index,ExecEnvVar item) {
    if (this.env == null) {this.env = new ArrayList<ExecEnvVarBuilder>();}
    ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);_visitables.get("env").add(index >= 0 ? index : _visitables.get("env").size(), builder);this.env.add(index >= 0 ? index : env.size(), builder); return (A)this;
  }
  public A setToEnv(Integer index,ExecEnvVar item) {
    if (this.env == null) {this.env = new ArrayList<ExecEnvVarBuilder>();}
    ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
    if (index < 0 || index >= _visitables.get("env").size()) { _visitables.get("env").add(builder); } else { _visitables.get("env").set(index, builder);}
    if (index < 0 || index >= env.size()) { env.add(builder); } else { env.set(index, builder);}
     return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.ExecEnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<ExecEnvVarBuilder>();}
    for (ExecEnvVar item : items) {ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A addAllToEnv(Collection<ExecEnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<ExecEnvVarBuilder>();}
    for (ExecEnvVar item : items) {ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.ExecEnvVar... items) {
    for (ExecEnvVar item : items) {ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
  }
  public A removeAllFromEnv(Collection<ExecEnvVar> items) {
    for (ExecEnvVar item : items) {ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEnv(Predicate<ExecEnvVarBuilder> predicate) {
    if (env == null) return (A) this;
    final Iterator<ExecEnvVarBuilder> each = env.iterator();
    final List visitables = _visitables.get("env");
    while (each.hasNext()) {
      ExecEnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEnv instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ExecEnvVar> getEnv() {
    return env != null ? build(env) : null;
  }
  public List<ExecEnvVar> buildEnv() {
    return env != null ? build(env) : null;
  }
  public ExecEnvVar buildEnv(Integer index) {
    return this.env.get(index).build();
  }
  public ExecEnvVar buildFirstEnv() {
    return this.env.get(0).build();
  }
  public ExecEnvVar buildLastEnv() {
    return this.env.get(env.size() - 1).build();
  }
  public ExecEnvVar buildMatchingEnv(Predicate<ExecEnvVarBuilder> predicate) {
    for (ExecEnvVarBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEnv(Predicate<ExecEnvVarBuilder> predicate) {
    for (ExecEnvVarBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<ExecEnvVar> env) {
    if (this.env != null) { _visitables.get("env").removeAll(this.env);}
    if (env != null) {this.env = new ArrayList(); for (ExecEnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.ExecEnvVar... env) {
    if (this.env != null) {this.env.clear();}
    if (env != null) {for (ExecEnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public A addNewEnv(String name,String value) {
    return (A)addToEnv(new ExecEnvVar(name, value));
  }
  public ExecConfigFluent.EnvNested<A> addNewEnv() {
    return new ExecConfigFluentImpl.EnvNestedImpl();
  }
  public ExecConfigFluent.EnvNested<A> addNewEnvLike(ExecEnvVar item) {
    return new ExecConfigFluentImpl.EnvNestedImpl(-1, item);
  }
  public ExecConfigFluent.EnvNested<A> setNewEnvLike(Integer index,ExecEnvVar item) {
    return new ExecConfigFluentImpl.EnvNestedImpl(index, item);
  }
  public ExecConfigFluent.EnvNested<A> editEnv(Integer index) {
    if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public ExecConfigFluent.EnvNested<A> editFirstEnv() {
    if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
    return setNewEnvLike(0, buildEnv(0));
  }
  public ExecConfigFluent.EnvNested<A> editLastEnv() {
    int index = env.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public ExecConfigFluent.EnvNested<A> editMatchingEnv(Predicate<ExecEnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<env.size();i++) { 
    if (predicate.test(env.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public String getInstallHint() {
    return this.installHint;
  }
  public A withInstallHint(String installHint) {
    this.installHint=installHint; return (A) this;
  }
  public Boolean hasInstallHint() {
    return this.installHint != null;
  }
  public String getInteractiveMode() {
    return this.interactiveMode;
  }
  public A withInteractiveMode(String interactiveMode) {
    this.interactiveMode=interactiveMode; return (A) this;
  }
  public Boolean hasInteractiveMode() {
    return this.interactiveMode != null;
  }
  public Boolean getProvideClusterInfo() {
    return this.provideClusterInfo;
  }
  public A withProvideClusterInfo(Boolean provideClusterInfo) {
    this.provideClusterInfo=provideClusterInfo; return (A) this;
  }
  public Boolean hasProvideClusterInfo() {
    return this.provideClusterInfo != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExecConfigFluentImpl that = (ExecConfigFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (args != null ? !args.equals(that.args) :that.args != null) return false;
    if (command != null ? !command.equals(that.command) :that.command != null) return false;
    if (env != null ? !env.equals(that.env) :that.env != null) return false;
    if (installHint != null ? !installHint.equals(that.installHint) :that.installHint != null) return false;
    if (interactiveMode != null ? !interactiveMode.equals(that.interactiveMode) :that.interactiveMode != null) return false;
    if (provideClusterInfo != null ? !provideClusterInfo.equals(that.provideClusterInfo) :that.provideClusterInfo != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  args,  command,  env,  installHint,  interactiveMode,  provideClusterInfo,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (args != null && !args.isEmpty()) { sb.append("args:"); sb.append(args + ","); }
    if (command != null) { sb.append("command:"); sb.append(command + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (installHint != null) { sb.append("installHint:"); sb.append(installHint + ","); }
    if (interactiveMode != null) { sb.append("interactiveMode:"); sb.append(interactiveMode + ","); }
    if (provideClusterInfo != null) { sb.append("provideClusterInfo:"); sb.append(provideClusterInfo + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withProvideClusterInfo() {
    return withProvideClusterInfo(true);
  }
  class EnvNestedImpl<N> extends ExecEnvVarFluentImpl<ExecConfigFluent.EnvNested<N>> implements ExecConfigFluent.EnvNested<N>,Nested<N>{
    EnvNestedImpl(Integer index,ExecEnvVar item) {
      this.index = index;
      this.builder = new ExecEnvVarBuilder(this, item);
    }
    EnvNestedImpl() {
      this.index = -1;
      this.builder = new ExecEnvVarBuilder(this);
    }
    ExecEnvVarBuilder builder;
    Integer index;
    public N and() {
      return (N) ExecConfigFluentImpl.this.setToEnv(index,builder.build());
    }
    public N endEnv() {
      return and();
    }
    
  }
  
}