package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * A holder for a value of any type - a wrapped primitive, an array, or object value.
  * <p>
  * It does not matter what the object type is, default serialization logic will be used.
  */
public class AnyTypeBuilder extends AnyTypeFluentImpl<AnyTypeBuilder> implements VisitableBuilder<AnyType,AnyTypeBuilder>{
  public AnyTypeBuilder() {
    this(false);
  }
  public AnyTypeBuilder(Boolean validationEnabled) {
    this(new AnyType(), validationEnabled);
  }
  public AnyTypeBuilder(AnyTypeFluent<?> fluent) {
    this(fluent, false);
  }
  public AnyTypeBuilder(AnyTypeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AnyType(), validationEnabled);
  }
  public AnyTypeBuilder(AnyTypeFluent<?> fluent,AnyType instance) {
    this(fluent, instance, false);
  }
  public AnyTypeBuilder(AnyTypeFluent<?> fluent,AnyType instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public AnyTypeBuilder(AnyType instance) {
    this(instance,false);
  }
  public AnyTypeBuilder(AnyType instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  AnyTypeFluent<?> fluent;
  Boolean validationEnabled;
  public AnyType build() {
    AnyType buildable = new AnyType(fluent.getValue());
    return buildable;
  }
  
}