/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeAddressFluent;
import io.fabric8.kubernetes.api.model.NodeAddressFluentImpl;

public class NodeAddressBuilder
extends NodeAddressFluentImpl<NodeAddressBuilder>
implements VisitableBuilder<NodeAddress, NodeAddressBuilder> {
    NodeAddressFluent<?> fluent;
    Boolean validationEnabled;

    public NodeAddressBuilder() {
        this(false);
    }

    public NodeAddressBuilder(Boolean validationEnabled) {
        this(new NodeAddress(), validationEnabled);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeAddress(), validationEnabled);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, NodeAddress instance) {
        this(fluent, instance, false);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, NodeAddress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withType(instance.getType());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NodeAddressBuilder(NodeAddress instance) {
        this(instance, (Boolean)false);
    }

    public NodeAddressBuilder(NodeAddress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NodeAddress build() {
        NodeAddress buildable = new NodeAddress(this.fluent.getAddress(), this.fluent.getType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

