package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceReferenceBuilder extends ServiceReferenceFluent<ServiceReferenceBuilder> implements VisitableBuilder<ServiceReference,ServiceReferenceBuilder>{
  public ServiceReferenceBuilder() {
    this(new ServiceReference());
  }
  
  public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent) {
    this(fluent, new ServiceReference());
  }
  
  public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent,ServiceReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceReferenceBuilder(ServiceReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceReferenceFluent<?> fluent;
  
  public ServiceReference build() {
    ServiceReference buildable = new ServiceReference(fluent.getName(),fluent.getNamespace(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}