package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeSelectorTermBuilder extends NodeSelectorTermFluent<NodeSelectorTermBuilder> implements VisitableBuilder<NodeSelectorTerm,NodeSelectorTermBuilder>{
  public NodeSelectorTermBuilder() {
    this(new NodeSelectorTerm());
  }
  
  public NodeSelectorTermBuilder(NodeSelectorTermFluent<?> fluent) {
    this(fluent, new NodeSelectorTerm());
  }
  
  public NodeSelectorTermBuilder(NodeSelectorTermFluent<?> fluent,NodeSelectorTerm instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeSelectorTermBuilder(NodeSelectorTerm instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeSelectorTermFluent<?> fluent;
  
  public NodeSelectorTerm build() {
    NodeSelectorTerm buildable = new NodeSelectorTerm(fluent.buildMatchExpressions(),fluent.buildMatchFields());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}