/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.ClusterBuilder;
import io.fabric8.kubernetes.api.model.ClusterFluentImpl;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedClusterFluent;
import java.util.Objects;

public class NamedClusterFluentImpl<A extends NamedClusterFluent<A>>
extends BaseFluent<A>
implements NamedClusterFluent<A> {
    private ClusterBuilder cluster;
    private String name;

    public NamedClusterFluentImpl() {
    }

    public NamedClusterFluentImpl(NamedCluster instance) {
        this.withCluster(instance.getCluster());
        this.withName(instance.getName());
    }

    @Override
    @Deprecated
    public Cluster getCluster() {
        return this.cluster != null ? this.cluster.build() : null;
    }

    @Override
    public Cluster buildCluster() {
        return this.cluster != null ? this.cluster.build() : null;
    }

    @Override
    public A withCluster(Cluster cluster) {
        this._visitables.get("cluster").remove(this.cluster);
        if (cluster != null) {
            this.cluster = new ClusterBuilder(cluster);
            this._visitables.get("cluster").add(this.cluster);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCluster() {
        return this.cluster != null;
    }

    @Override
    public NamedClusterFluent.ClusterNested<A> withNewCluster() {
        return new ClusterNestedImpl();
    }

    @Override
    public NamedClusterFluent.ClusterNested<A> withNewClusterLike(Cluster item) {
        return new ClusterNestedImpl(item);
    }

    @Override
    public NamedClusterFluent.ClusterNested<A> editCluster() {
        return this.withNewClusterLike(this.getCluster());
    }

    @Override
    public NamedClusterFluent.ClusterNested<A> editOrNewCluster() {
        return this.withNewClusterLike(this.getCluster() != null ? this.getCluster() : new ClusterBuilder().build());
    }

    @Override
    public NamedClusterFluent.ClusterNested<A> editOrNewClusterLike(Cluster item) {
        return this.withNewClusterLike(this.getCluster() != null ? this.getCluster() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedClusterFluentImpl that = (NamedClusterFluentImpl)o;
        if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.name, super.hashCode());
    }

    public class ClusterNestedImpl<N>
    extends ClusterFluentImpl<NamedClusterFluent.ClusterNested<N>>
    implements NamedClusterFluent.ClusterNested<N>,
    Nested<N> {
        private final ClusterBuilder builder;

        ClusterNestedImpl(Cluster item) {
            this.builder = new ClusterBuilder(this, item);
        }

        ClusterNestedImpl() {
            this.builder = new ClusterBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamedClusterFluentImpl.this.withCluster(this.builder.build());
        }

        @Override
        public N endCluster() {
            return this.and();
        }
    }
}

