package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PreferencesFluentImpl<A extends io.fabric8.kubernetes.api.model.PreferencesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.PreferencesFluent<A> {

    private java.lang.Boolean colors;
    private java.util.List<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> extensions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();

    public PreferencesFluentImpl() {
    }

    public PreferencesFluentImpl(io.fabric8.kubernetes.api.model.Preferences instance) {
        this.withColors(instance.getColors()); 
        this.withExtensions(instance.getExtensions()); 
    }

    public java.lang.Boolean getColors() {
        return this.colors;
    }

    public A withColors(java.lang.Boolean colors) {
        this.colors=colors; return (A) this;
    }

    public java.lang.Boolean hasColors() {
        return this.colors != null;
    }

    public A addToExtensions(int index,io.fabric8.kubernetes.api.model.NamedExtension item) {
        if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
        io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").add(index >= 0 ? index : _visitables.get("extensions").size(), builder);this.extensions.add(index >= 0 ? index : extensions.size(), builder); return (A)this;
    }

    public A setToExtensions(int index,io.fabric8.kubernetes.api.model.NamedExtension item) {
        if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
        io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);
        if (index < 0 || index >= _visitables.get("extensions").size()) { _visitables.get("extensions").add(builder); } else { _visitables.get("extensions").set(index, builder);}
        if (index < 0 || index >= extensions.size()) { extensions.add(builder); } else { extensions.set(index, builder);}
         return (A)this;
    }

    public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
        if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
        for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
    }

    public A addAllToExtensions(java.util.Collection<io.fabric8.kubernetes.api.model.NamedExtension> items) {
        if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
        for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
    }

    public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
        for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
    }

    public A removeAllFromExtensions(java.util.Collection<io.fabric8.kubernetes.api.model.NamedExtension> items) {
        for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromExtensions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
        if (extensions == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> each = extensions.iterator();
        final List visitables = _visitables.get("extensions");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildExtensions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> getExtensions() {
        return build(extensions);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> buildExtensions() {
        return build(extensions);
    }

    public io.fabric8.kubernetes.api.model.NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.NamedExtension buildLastExtension() {
        return this.extensions.get(extensions.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.NamedExtension buildMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withExtensions(java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> extensions) {
        if (this.extensions != null) { _visitables.get("extensions").removeAll(this.extensions);}
        if (extensions != null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>(); for (io.fabric8.kubernetes.api.model.NamedExtension item : extensions){this.addToExtensions(item);}} else { this.extensions = null;} return (A) this;
    }

    public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions) {
        if (this.extensions != null) {this.extensions.clear();}
        if (extensions != null) {for (io.fabric8.kubernetes.api.model.NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
    }

    public java.lang.Boolean hasExtensions() {
        return extensions != null && !extensions.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.PreferencesFluent.ExtensionsNested<A> addNewExtension() {
        return new io.fabric8.kubernetes.api.model.PreferencesFluentImpl.ExtensionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.PreferencesFluent.ExtensionsNested<A> addNewExtensionLike(io.fabric8.kubernetes.api.model.NamedExtension item) {
        return new io.fabric8.kubernetes.api.model.PreferencesFluentImpl.ExtensionsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.PreferencesFluent.ExtensionsNested<A> setNewExtensionLike(int index,io.fabric8.kubernetes.api.model.NamedExtension item) {
        return new io.fabric8.kubernetes.api.model.PreferencesFluentImpl.ExtensionsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.PreferencesFluent.ExtensionsNested<A> editExtension(int index) {
        if (extensions.size() <= index) throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        return setNewExtensionLike(index, buildExtension(index));
    }

    public io.fabric8.kubernetes.api.model.PreferencesFluent.ExtensionsNested<A> editFirstExtension() {
        if (extensions.size() == 0) throw new RuntimeException("Can't edit first extensions. The list is empty.");
        return setNewExtensionLike(0, buildExtension(0));
    }

    public io.fabric8.kubernetes.api.model.PreferencesFluent.ExtensionsNested<A> editLastExtension() {
        int index = extensions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last extensions. The list is empty.");
        return setNewExtensionLike(index, buildExtension(index));
    }

    public io.fabric8.kubernetes.api.model.PreferencesFluent.ExtensionsNested<A> editMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<extensions.size();i++) { 
        if (predicate.test(extensions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching extensions. No match found.");
        return setNewExtensionLike(index, buildExtension(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PreferencesFluentImpl that = (PreferencesFluentImpl) o;
        if (colors != null ? !colors.equals(that.colors) :that.colors != null) return false;
        if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(colors,  extensions,  super.hashCode());
    }

    public class ExtensionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl<io.fabric8.kubernetes.api.model.PreferencesFluent.ExtensionsNested<N>> implements io.fabric8.kubernetes.api.model.PreferencesFluent.ExtensionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder;
        private final int index;

            ExtensionsNestedImpl(int index,io.fabric8.kubernetes.api.model.NamedExtension item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(this, item);
                        
            }

            ExtensionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(this);
                        
            }

            public N and() {
                return (N) PreferencesFluentImpl.this.setToExtensions(index,builder.build());
            }

            public N endExtension() {
                return and();
            }
    }


}
