package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LimitRangeListBuilder extends io.fabric8.kubernetes.api.model.LimitRangeListFluentImpl<io.fabric8.kubernetes.api.model.LimitRangeListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.LimitRangeList,io.fabric8.kubernetes.api.model.LimitRangeListBuilder> {

    io.fabric8.kubernetes.api.model.LimitRangeListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public LimitRangeListBuilder() {
        this(true);
    }

    public LimitRangeListBuilder(java.lang.Boolean validationEnabled) {
        this(new LimitRangeList(), validationEnabled);
    }

    public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeListFluent<?> fluent) {
        this(fluent, true);
    }

    public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new LimitRangeList(), validationEnabled);
    }

    public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeListFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRangeList instance) {
        this(fluent, instance, true);
    }

    public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeListFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRangeList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeList instance) {
        this(instance,true);
    }

    public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.LimitRangeList build() {
        LimitRangeList buildable = new LimitRangeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LimitRangeListBuilder that = (LimitRangeListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
