package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface APIGroupFluent<A extends io.fabric8.kubernetes.api.model.APIGroupFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getApiVersion();
    public A withApiVersion(java.lang.String apiVersion);
    public java.lang.Boolean hasApiVersion();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0);
    public java.lang.String getKind();
    public A withKind(java.lang.String kind);
    public java.lang.Boolean hasKind();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0);
    public java.lang.String getName();
    public A withName(java.lang.String name);
    public java.lang.Boolean hasName();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPreferredVersion instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery getPreferredVersion();
    public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery buildPreferredVersion();
    public A withPreferredVersion(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery preferredVersion);
    public java.lang.Boolean hasPreferredVersion();
    public A withNewPreferredVersion(java.lang.String groupVersion,java.lang.String version);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersionLike(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> editPreferredVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersionLike(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item);
    public A addToServerAddressByClientCIDRs(int index,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item);
    public A setToServerAddressByClientCIDRs(int index,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item);
    public A addToServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... items);
    public A addAllToServerAddressByClientCIDRs(java.util.Collection<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR> items);
    public A removeFromServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... items);
    public A removeAllFromServerAddressByClientCIDRs(java.util.Collection<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR> items);
    public A removeMatchingFromServerAddressByClientCIDRs(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServerAddressByClientCIDRs instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR> getServerAddressByClientCIDRs();
    public java.util.List<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR> buildServerAddressByClientCIDRs();
    public io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index);
    public io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR();
    public io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR buildLastServerAddressByClientCIDR();
    public io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> predicate);
    public java.lang.Boolean hasMatchingServerAddressByClientCIDR(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> predicate);
    public A withServerAddressByClientCIDRs(java.util.List<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR> serverAddressByClientCIDRs);
    public A withServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... serverAddressByClientCIDRs);
    public java.lang.Boolean hasServerAddressByClientCIDRs();
    public A addNewServerAddressByClientCIDR(java.lang.String clientCIDR,java.lang.String serverAddress);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> predicate);
    public A addToVersions(int index,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item);
    public A setToVersions(int index,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item);
    public A addToVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... items);
    public A addAllToVersions(java.util.Collection<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery> items);
    public A removeFromVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... items);
    public A removeAllFromVersions(java.util.Collection<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery> items);
    public A removeMatchingFromVersions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVersions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery> getVersions();
    public java.util.List<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery> buildVersions();
    public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery buildVersion(int index);
    public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery buildFirstVersion();
    public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery buildLastVersion();
    public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery buildMatchingVersion(java.util.function.Predicate<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> predicate);
    public java.lang.Boolean hasMatchingVersion(java.util.function.Predicate<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> predicate);
    public A withVersions(java.util.List<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery> versions);
    public A withVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... versions);
    public java.lang.Boolean hasVersions();
    public A addNewVersion(java.lang.String groupVersion,java.lang.String version);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> addNewVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> addNewVersionLike(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> setNewVersionLike(int index,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editVersion(int index);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editFirstVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editLastVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editMatchingVersion(java.util.function.Predicate<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> predicate);
    public interface PreferredVersionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<N>> {

            public N and();
            public N endPreferredVersion();    }


    public interface ServerAddressByClientCIDRsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent<io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<N>> {

            public N and();
            public N endServerAddressByClientCIDR();    }


    public interface VersionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<N>> {

            public N and();
            public N endVersion();    }


}
