package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class SecretBuilder extends io.fabric8.kubernetes.api.model.SecretFluentImpl<io.fabric8.kubernetes.api.model.SecretBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Secret,io.fabric8.kubernetes.api.model.SecretBuilder>{
  public SecretBuilder() {
    this(false);
  }
  public SecretBuilder(java.lang.Boolean validationEnabled) {
    this(new Secret(), validationEnabled);
  }
  public SecretBuilder(io.fabric8.kubernetes.api.model.SecretFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretBuilder(io.fabric8.kubernetes.api.model.SecretFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Secret(), validationEnabled);
  }
  public SecretBuilder(io.fabric8.kubernetes.api.model.SecretFluent<?> fluent,io.fabric8.kubernetes.api.model.Secret instance) {
    this(fluent, instance, false);
  }
  public SecretBuilder(io.fabric8.kubernetes.api.model.SecretFluent<?> fluent,io.fabric8.kubernetes.api.model.Secret instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withData(instance.getData()); 
    fluent.withImmutable(instance.getImmutable()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withStringData(instance.getStringData()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretBuilder(io.fabric8.kubernetes.api.model.Secret instance) {
    this(instance,false);
  }
  public SecretBuilder(io.fabric8.kubernetes.api.model.Secret instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withData(instance.getData()); 
    this.withImmutable(instance.getImmutable()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withStringData(instance.getStringData()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SecretFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Secret build() {
    Secret buildable = new Secret(fluent.getApiVersion(),fluent.getData(),fluent.getImmutable(),fluent.getKind(),fluent.getMetadata(),fluent.getStringData(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecretBuilder that = (SecretBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}