package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class PodStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.PodStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.PodStatusFluent<A>{
  public PodStatusFluentImpl() {
  }
  public PodStatusFluentImpl(io.fabric8.kubernetes.api.model.PodStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withContainerStatuses(instance.getContainerStatuses()); 
    this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses()); 
    this.withHostIP(instance.getHostIP()); 
    this.withInitContainerStatuses(instance.getInitContainerStatuses()); 
    this.withMessage(instance.getMessage()); 
    this.withNominatedNodeName(instance.getNominatedNodeName()); 
    this.withPhase(instance.getPhase()); 
    this.withPodIP(instance.getPodIP()); 
    this.withPodIPs(instance.getPodIPs()); 
    this.withQosClass(instance.getQosClass()); 
    this.withReason(instance.getReason()); 
    this.withStartTime(instance.getStartTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.PodConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodConditionBuilder>();
  private java.util.List<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> containerStatuses =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();
  private java.util.List<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> ephemeralContainerStatuses =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();
  private java.lang.String hostIP;
  private java.util.List<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> initContainerStatuses =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();
  private java.lang.String message;
  private java.lang.String nominatedNodeName;
  private java.lang.String phase;
  private java.lang.String podIP;
  private java.util.List<io.fabric8.kubernetes.api.model.PodIPBuilder> podIPs =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodIPBuilder>();
  private java.lang.String qosClass;
  private java.lang.String reason;
  private java.lang.String startTime;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodConditionBuilder>();}
    io.fabric8.kubernetes.api.model.PodConditionBuilder builder = new io.fabric8.kubernetes.api.model.PodConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodConditionBuilder>();}
    io.fabric8.kubernetes.api.model.PodConditionBuilder builder = new io.fabric8.kubernetes.api.model.PodConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.PodCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.PodCondition item : items) {io.fabric8.kubernetes.api.model.PodConditionBuilder builder = new io.fabric8.kubernetes.api.model.PodConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.PodCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.PodCondition item : items) {io.fabric8.kubernetes.api.model.PodConditionBuilder builder = new io.fabric8.kubernetes.api.model.PodConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.PodCondition... items) {
    for (io.fabric8.kubernetes.api.model.PodCondition item : items) {io.fabric8.kubernetes.api.model.PodConditionBuilder builder = new io.fabric8.kubernetes.api.model.PodConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.PodCondition> items) {
    for (io.fabric8.kubernetes.api.model.PodCondition item : items) {io.fabric8.kubernetes.api.model.PodConditionBuilder builder = new io.fabric8.kubernetes.api.model.PodConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.PodConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.PodConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.PodCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.PodCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.kubernetes.api.model.PodCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.PodCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.PodCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.PodCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.PodConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.PodConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.PodCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.PodCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.PodCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.PodCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.PodCondition item) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodCondition item) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToContainerStatuses(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
    if (this.containerStatuses == null) {this.containerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(index >= 0 ? index : _visitables.get("containerStatuses").size(), builder);this.containerStatuses.add(index >= 0 ? index : containerStatuses.size(), builder); return (A)this;
  }
  public A setToContainerStatuses(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
    if (this.containerStatuses == null) {this.containerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("containerStatuses").size()) { _visitables.get("containerStatuses").add(builder); } else { _visitables.get("containerStatuses").set(index, builder);}
    if (index < 0 || index >= containerStatuses.size()) { containerStatuses.add(builder); } else { containerStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    if (this.containerStatuses == null) {this.containerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
  }
  public A addAllToContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items) {
    if (this.containerStatuses == null) {this.containerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
  }
  public A removeFromContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items) {
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainerStatuses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    if (containerStatuses == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> each = containerStatuses.iterator();
    final List visitables = _visitables.get("containerStatuses");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainerStatuses instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> getContainerStatuses() {
    return build(containerStatuses);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> buildContainerStatuses() {
    return build(containerStatuses);
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildContainerStatus(java.lang.Integer index) {
    return this.containerStatuses.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildFirstContainerStatus() {
    return this.containerStatuses.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildLastContainerStatus() {
    return this.containerStatuses.get(containerStatuses.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildMatchingContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerStatusBuilder item: containerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerStatusBuilder item: containerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerStatuses(java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> containerStatuses) {
    if (this.containerStatuses != null) { _visitables.get("containerStatuses").removeAll(this.containerStatuses);}
    if (containerStatuses != null) {this.containerStatuses = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.ContainerStatus item : containerStatuses){this.addToContainerStatuses(item);}} else { this.containerStatuses = null;} return (A) this;
  }
  public A withContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... containerStatuses) {
    if (this.containerStatuses != null) {this.containerStatuses.clear();}
    if (containerStatuses != null) {for (io.fabric8.kubernetes.api.model.ContainerStatus item :containerStatuses){ this.addToContainerStatuses(item);}} return (A) this;
  }
  public java.lang.Boolean hasContainerStatuses() {
    return containerStatuses != null && !containerStatuses.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.ContainerStatusesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(io.fabric8.kubernetes.api.model.ContainerStatus item) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.ContainerStatusesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.ContainerStatusesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(java.lang.Integer index) {
    if (containerStatuses.size() <= index) throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
    if (containerStatuses.size() == 0) throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
    return setNewContainerStatusLike(0, buildContainerStatus(0));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
    int index = containerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containerStatuses.size();i++) { 
    if (predicate.test(containerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public A addToEphemeralContainerStatuses(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
    if (this.ephemeralContainerStatuses == null) {this.ephemeralContainerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("ephemeralContainerStatuses").add(index >= 0 ? index : _visitables.get("ephemeralContainerStatuses").size(), builder);this.ephemeralContainerStatuses.add(index >= 0 ? index : ephemeralContainerStatuses.size(), builder); return (A)this;
  }
  public A setToEphemeralContainerStatuses(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
    if (this.ephemeralContainerStatuses == null) {this.ephemeralContainerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("ephemeralContainerStatuses").size()) { _visitables.get("ephemeralContainerStatuses").add(builder); } else { _visitables.get("ephemeralContainerStatuses").set(index, builder);}
    if (index < 0 || index >= ephemeralContainerStatuses.size()) { ephemeralContainerStatuses.add(builder); } else { ephemeralContainerStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    if (this.ephemeralContainerStatuses == null) {this.ephemeralContainerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("ephemeralContainerStatuses").add(builder);this.ephemeralContainerStatuses.add(builder);} return (A)this;
  }
  public A addAllToEphemeralContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items) {
    if (this.ephemeralContainerStatuses == null) {this.ephemeralContainerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("ephemeralContainerStatuses").add(builder);this.ephemeralContainerStatuses.add(builder);} return (A)this;
  }
  public A removeFromEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("ephemeralContainerStatuses").remove(builder);if (this.ephemeralContainerStatuses != null) {this.ephemeralContainerStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromEphemeralContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items) {
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("ephemeralContainerStatuses").remove(builder);if (this.ephemeralContainerStatuses != null) {this.ephemeralContainerStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEphemeralContainerStatuses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    if (ephemeralContainerStatuses == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> each = ephemeralContainerStatuses.iterator();
    final List visitables = _visitables.get("ephemeralContainerStatuses");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEphemeralContainerStatuses instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> getEphemeralContainerStatuses() {
    return build(ephemeralContainerStatuses);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> buildEphemeralContainerStatuses() {
    return build(ephemeralContainerStatuses);
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildEphemeralContainerStatus(java.lang.Integer index) {
    return this.ephemeralContainerStatuses.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildFirstEphemeralContainerStatus() {
    return this.ephemeralContainerStatuses.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildLastEphemeralContainerStatus() {
    return this.ephemeralContainerStatuses.get(ephemeralContainerStatuses.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildMatchingEphemeralContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerStatusBuilder item: ephemeralContainerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingEphemeralContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerStatusBuilder item: ephemeralContainerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEphemeralContainerStatuses(java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> ephemeralContainerStatuses) {
    if (this.ephemeralContainerStatuses != null) { _visitables.get("ephemeralContainerStatuses").removeAll(this.ephemeralContainerStatuses);}
    if (ephemeralContainerStatuses != null) {this.ephemeralContainerStatuses = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.ContainerStatus item : ephemeralContainerStatuses){this.addToEphemeralContainerStatuses(item);}} else { this.ephemeralContainerStatuses = null;} return (A) this;
  }
  public A withEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... ephemeralContainerStatuses) {
    if (this.ephemeralContainerStatuses != null) {this.ephemeralContainerStatuses.clear();}
    if (ephemeralContainerStatuses != null) {for (io.fabric8.kubernetes.api.model.ContainerStatus item :ephemeralContainerStatuses){ this.addToEphemeralContainerStatuses(item);}} return (A) this;
  }
  public java.lang.Boolean hasEphemeralContainerStatuses() {
    return ephemeralContainerStatuses != null && !ephemeralContainerStatuses.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatus() {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.EphemeralContainerStatusesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatusLike(io.fabric8.kubernetes.api.model.ContainerStatus item) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.EphemeralContainerStatusesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> setNewEphemeralContainerStatusLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.EphemeralContainerStatusesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editEphemeralContainerStatus(java.lang.Integer index) {
    if (ephemeralContainerStatuses.size() <= index) throw new RuntimeException("Can't edit ephemeralContainerStatuses. Index exceeds size.");
    return setNewEphemeralContainerStatusLike(index, buildEphemeralContainerStatus(index));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editFirstEphemeralContainerStatus() {
    if (ephemeralContainerStatuses.size() == 0) throw new RuntimeException("Can't edit first ephemeralContainerStatuses. The list is empty.");
    return setNewEphemeralContainerStatusLike(0, buildEphemeralContainerStatus(0));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editLastEphemeralContainerStatus() {
    int index = ephemeralContainerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ephemeralContainerStatuses. The list is empty.");
    return setNewEphemeralContainerStatusLike(index, buildEphemeralContainerStatus(index));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editMatchingEphemeralContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ephemeralContainerStatuses.size();i++) { 
    if (predicate.test(ephemeralContainerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ephemeralContainerStatuses. No match found.");
    return setNewEphemeralContainerStatusLike(index, buildEphemeralContainerStatus(index));
  }
  public java.lang.String getHostIP() {
    return this.hostIP;
  }
  public A withHostIP(java.lang.String hostIP) {
    this.hostIP=hostIP; return (A) this;
  }
  public java.lang.Boolean hasHostIP() {
    return this.hostIP != null;
  }
  
  /**
   * Method is deprecated. use withHostIP instead.
   */
  @java.lang.Deprecated
  public A withNewHostIP(java.lang.String arg0) {
    return (A)withHostIP(new String(arg0));
  }
  public A addToInitContainerStatuses(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(index >= 0 ? index : _visitables.get("initContainerStatuses").size(), builder);this.initContainerStatuses.add(index >= 0 ? index : initContainerStatuses.size(), builder); return (A)this;
  }
  public A setToInitContainerStatuses(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainerStatuses").size()) { _visitables.get("initContainerStatuses").add(builder); } else { _visitables.get("initContainerStatuses").set(index, builder);}
    if (index < 0 || index >= initContainerStatuses.size()) { initContainerStatuses.add(builder); } else { initContainerStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(builder);this.initContainerStatuses.add(builder);} return (A)this;
  }
  public A addAllToInitContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerStatusBuilder>();}
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(builder);this.initContainerStatuses.add(builder);} return (A)this;
  }
  public A removeFromInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").remove(builder);if (this.initContainerStatuses != null) {this.initContainerStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items) {
    for (io.fabric8.kubernetes.api.model.ContainerStatus item : items) {io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").remove(builder);if (this.initContainerStatuses != null) {this.initContainerStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainerStatuses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    if (initContainerStatuses == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> each = initContainerStatuses.iterator();
    final List visitables = _visitables.get("initContainerStatuses");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainerStatuses instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> getInitContainerStatuses() {
    return build(initContainerStatuses);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> buildInitContainerStatuses() {
    return build(initContainerStatuses);
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildInitContainerStatus(java.lang.Integer index) {
    return this.initContainerStatuses.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildFirstInitContainerStatus() {
    return this.initContainerStatuses.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildLastInitContainerStatus() {
    return this.initContainerStatuses.get(initContainerStatuses.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildMatchingInitContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerStatusBuilder item: initContainerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingInitContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerStatusBuilder item: initContainerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInitContainerStatuses(java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> initContainerStatuses) {
    if (this.initContainerStatuses != null) { _visitables.get("initContainerStatuses").removeAll(this.initContainerStatuses);}
    if (initContainerStatuses != null) {this.initContainerStatuses = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.ContainerStatus item : initContainerStatuses){this.addToInitContainerStatuses(item);}} else { this.initContainerStatuses = null;} return (A) this;
  }
  public A withInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... initContainerStatuses) {
    if (this.initContainerStatuses != null) {this.initContainerStatuses.clear();}
    if (initContainerStatuses != null) {for (io.fabric8.kubernetes.api.model.ContainerStatus item :initContainerStatuses){ this.addToInitContainerStatuses(item);}} return (A) this;
  }
  public java.lang.Boolean hasInitContainerStatuses() {
    return initContainerStatuses != null && !initContainerStatuses.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus() {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.InitContainerStatusesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(io.fabric8.kubernetes.api.model.ContainerStatus item) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.InitContainerStatusesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.InitContainerStatusesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(java.lang.Integer index) {
    if (initContainerStatuses.size() <= index) throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus() {
    if (initContainerStatuses.size() == 0) throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
    return setNewInitContainerStatusLike(0, buildInitContainerStatus(0));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus() {
    int index = initContainerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainerStatuses.size();i++) { 
    if (predicate.test(initContainerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  public java.lang.String getMessage() {
    return this.message;
  }
  public A withMessage(java.lang.String message) {
    this.message=message; return (A) this;
  }
  public java.lang.Boolean hasMessage() {
    return this.message != null;
  }
  
  /**
   * Method is deprecated. use withMessage instead.
   */
  @java.lang.Deprecated
  public A withNewMessage(java.lang.String arg0) {
    return (A)withMessage(new String(arg0));
  }
  public java.lang.String getNominatedNodeName() {
    return this.nominatedNodeName;
  }
  public A withNominatedNodeName(java.lang.String nominatedNodeName) {
    this.nominatedNodeName=nominatedNodeName; return (A) this;
  }
  public java.lang.Boolean hasNominatedNodeName() {
    return this.nominatedNodeName != null;
  }
  
  /**
   * Method is deprecated. use withNominatedNodeName instead.
   */
  @java.lang.Deprecated
  public A withNewNominatedNodeName(java.lang.String arg0) {
    return (A)withNominatedNodeName(new String(arg0));
  }
  public java.lang.String getPhase() {
    return this.phase;
  }
  public A withPhase(java.lang.String phase) {
    this.phase=phase; return (A) this;
  }
  public java.lang.Boolean hasPhase() {
    return this.phase != null;
  }
  
  /**
   * Method is deprecated. use withPhase instead.
   */
  @java.lang.Deprecated
  public A withNewPhase(java.lang.String arg0) {
    return (A)withPhase(new String(arg0));
  }
  public java.lang.String getPodIP() {
    return this.podIP;
  }
  public A withPodIP(java.lang.String podIP) {
    this.podIP=podIP; return (A) this;
  }
  public java.lang.Boolean hasPodIP() {
    return this.podIP != null;
  }
  
  /**
   * Method is deprecated. use withPodIP instead.
   */
  @java.lang.Deprecated
  public A withNewPodIP(java.lang.String arg0) {
    return (A)withPodIP(new String(arg0));
  }
  public A addToPodIPs(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodIP item) {
    if (this.podIPs == null) {this.podIPs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodIPBuilder>();}
    io.fabric8.kubernetes.api.model.PodIPBuilder builder = new io.fabric8.kubernetes.api.model.PodIPBuilder(item);_visitables.get("podIPs").add(index >= 0 ? index : _visitables.get("podIPs").size(), builder);this.podIPs.add(index >= 0 ? index : podIPs.size(), builder); return (A)this;
  }
  public A setToPodIPs(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodIP item) {
    if (this.podIPs == null) {this.podIPs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodIPBuilder>();}
    io.fabric8.kubernetes.api.model.PodIPBuilder builder = new io.fabric8.kubernetes.api.model.PodIPBuilder(item);
    if (index < 0 || index >= _visitables.get("podIPs").size()) { _visitables.get("podIPs").add(builder); } else { _visitables.get("podIPs").set(index, builder);}
    if (index < 0 || index >= podIPs.size()) { podIPs.add(builder); } else { podIPs.set(index, builder);}
     return (A)this;
  }
  public A addToPodIPs(io.fabric8.kubernetes.api.model.PodIP... items) {
    if (this.podIPs == null) {this.podIPs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodIPBuilder>();}
    for (io.fabric8.kubernetes.api.model.PodIP item : items) {io.fabric8.kubernetes.api.model.PodIPBuilder builder = new io.fabric8.kubernetes.api.model.PodIPBuilder(item);_visitables.get("podIPs").add(builder);this.podIPs.add(builder);} return (A)this;
  }
  public A addAllToPodIPs(java.util.Collection<io.fabric8.kubernetes.api.model.PodIP> items) {
    if (this.podIPs == null) {this.podIPs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodIPBuilder>();}
    for (io.fabric8.kubernetes.api.model.PodIP item : items) {io.fabric8.kubernetes.api.model.PodIPBuilder builder = new io.fabric8.kubernetes.api.model.PodIPBuilder(item);_visitables.get("podIPs").add(builder);this.podIPs.add(builder);} return (A)this;
  }
  public A removeFromPodIPs(io.fabric8.kubernetes.api.model.PodIP... items) {
    for (io.fabric8.kubernetes.api.model.PodIP item : items) {io.fabric8.kubernetes.api.model.PodIPBuilder builder = new io.fabric8.kubernetes.api.model.PodIPBuilder(item);_visitables.get("podIPs").remove(builder);if (this.podIPs != null) {this.podIPs.remove(builder);}} return (A)this;
  }
  public A removeAllFromPodIPs(java.util.Collection<io.fabric8.kubernetes.api.model.PodIP> items) {
    for (io.fabric8.kubernetes.api.model.PodIP item : items) {io.fabric8.kubernetes.api.model.PodIPBuilder builder = new io.fabric8.kubernetes.api.model.PodIPBuilder(item);_visitables.get("podIPs").remove(builder);if (this.podIPs != null) {this.podIPs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPodIPs(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodIPBuilder> predicate) {
    if (podIPs == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.PodIPBuilder> each = podIPs.iterator();
    final List visitables = _visitables.get("podIPs");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.PodIPBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPodIPs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.PodIP> getPodIPs() {
    return build(podIPs);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.PodIP> buildPodIPs() {
    return build(podIPs);
  }
  public io.fabric8.kubernetes.api.model.PodIP buildPodIP(java.lang.Integer index) {
    return this.podIPs.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.PodIP buildFirstPodIP() {
    return this.podIPs.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.PodIP buildLastPodIP() {
    return this.podIPs.get(podIPs.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.PodIP buildMatchingPodIP(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodIPBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.PodIPBuilder item: podIPs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingPodIP(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodIPBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.PodIPBuilder item: podIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPodIPs(java.util.List<io.fabric8.kubernetes.api.model.PodIP> podIPs) {
    if (this.podIPs != null) { _visitables.get("podIPs").removeAll(this.podIPs);}
    if (podIPs != null) {this.podIPs = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.PodIP item : podIPs){this.addToPodIPs(item);}} else { this.podIPs = null;} return (A) this;
  }
  public A withPodIPs(io.fabric8.kubernetes.api.model.PodIP... podIPs) {
    if (this.podIPs != null) {this.podIPs.clear();}
    if (podIPs != null) {for (io.fabric8.kubernetes.api.model.PodIP item :podIPs){ this.addToPodIPs(item);}} return (A) this;
  }
  public java.lang.Boolean hasPodIPs() {
    return podIPs != null && !podIPs.isEmpty();
  }
  public A addNewPodIP(java.lang.String ip) {
    return (A)addToPodIPs(new PodIP(ip));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> addNewPodIP() {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.PodIPsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> addNewPodIPLike(io.fabric8.kubernetes.api.model.PodIP item) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.PodIPsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> setNewPodIPLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodIP item) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentImpl.PodIPsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editPodIP(java.lang.Integer index) {
    if (podIPs.size() <= index) throw new RuntimeException("Can't edit podIPs. Index exceeds size.");
    return setNewPodIPLike(index, buildPodIP(index));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editFirstPodIP() {
    if (podIPs.size() == 0) throw new RuntimeException("Can't edit first podIPs. The list is empty.");
    return setNewPodIPLike(0, buildPodIP(0));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editLastPodIP() {
    int index = podIPs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last podIPs. The list is empty.");
    return setNewPodIPLike(index, buildPodIP(index));
  }
  public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editMatchingPodIP(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodIPBuilder> predicate) {
    int index = -1;
    for (int i=0;i<podIPs.size();i++) { 
    if (predicate.test(podIPs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching podIPs. No match found.");
    return setNewPodIPLike(index, buildPodIP(index));
  }
  public java.lang.String getQosClass() {
    return this.qosClass;
  }
  public A withQosClass(java.lang.String qosClass) {
    this.qosClass=qosClass; return (A) this;
  }
  public java.lang.Boolean hasQosClass() {
    return this.qosClass != null;
  }
  
  /**
   * Method is deprecated. use withQosClass instead.
   */
  @java.lang.Deprecated
  public A withNewQosClass(java.lang.String arg0) {
    return (A)withQosClass(new String(arg0));
  }
  public java.lang.String getReason() {
    return this.reason;
  }
  public A withReason(java.lang.String reason) {
    this.reason=reason; return (A) this;
  }
  public java.lang.Boolean hasReason() {
    return this.reason != null;
  }
  
  /**
   * Method is deprecated. use withReason instead.
   */
  @java.lang.Deprecated
  public A withNewReason(java.lang.String arg0) {
    return (A)withReason(new String(arg0));
  }
  public java.lang.String getStartTime() {
    return this.startTime;
  }
  public A withStartTime(java.lang.String startTime) {
    this.startTime=startTime; return (A) this;
  }
  public java.lang.Boolean hasStartTime() {
    return this.startTime != null;
  }
  
  /**
   * Method is deprecated. use withStartTime instead.
   */
  @java.lang.Deprecated
  public A withNewStartTime(java.lang.String arg0) {
    return (A)withStartTime(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodStatusFluentImpl that = (PodStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (containerStatuses != null ? !containerStatuses.equals(that.containerStatuses) :that.containerStatuses != null) return false;
    if (ephemeralContainerStatuses != null ? !ephemeralContainerStatuses.equals(that.ephemeralContainerStatuses) :that.ephemeralContainerStatuses != null) return false;
    if (hostIP != null ? !hostIP.equals(that.hostIP) :that.hostIP != null) return false;
    if (initContainerStatuses != null ? !initContainerStatuses.equals(that.initContainerStatuses) :that.initContainerStatuses != null) return false;
    if (message != null ? !message.equals(that.message) :that.message != null) return false;
    if (nominatedNodeName != null ? !nominatedNodeName.equals(that.nominatedNodeName) :that.nominatedNodeName != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (podIP != null ? !podIP.equals(that.podIP) :that.podIP != null) return false;
    if (podIPs != null ? !podIPs.equals(that.podIPs) :that.podIPs != null) return false;
    if (qosClass != null ? !qosClass.equals(that.qosClass) :that.qosClass != null) return false;
    if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
    if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  containerStatuses,  ephemeralContainerStatuses,  hostIP,  initContainerStatuses,  message,  nominatedNodeName,  phase,  podIP,  podIPs,  qosClass,  reason,  startTime,  additionalProperties,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.PodConditionFluentImpl<io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodCondition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.PodConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.PodConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class ContainerStatusesNestedImpl<N> extends io.fabric8.kubernetes.api.model.ContainerStatusFluentImpl<io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<N>> implements io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ContainerStatusesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(this, item);
    }
    ContainerStatusesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodStatusFluentImpl.this.setToContainerStatuses(index,builder.build());
    }
    public N endContainerStatus() {
      return and();
    }
    
  }
  public class EphemeralContainerStatusesNestedImpl<N> extends io.fabric8.kubernetes.api.model.ContainerStatusFluentImpl<io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<N>> implements io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EphemeralContainerStatusesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(this, item);
    }
    EphemeralContainerStatusesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodStatusFluentImpl.this.setToEphemeralContainerStatuses(index,builder.build());
    }
    public N endEphemeralContainerStatus() {
      return and();
    }
    
  }
  public class InitContainerStatusesNestedImpl<N> extends io.fabric8.kubernetes.api.model.ContainerStatusFluentImpl<io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<N>> implements io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    InitContainerStatusesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerStatus item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(this, item);
    }
    InitContainerStatusesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodStatusFluentImpl.this.setToInitContainerStatuses(index,builder.build());
    }
    public N endInitContainerStatus() {
      return and();
    }
    
  }
  public class PodIPsNestedImpl<N> extends io.fabric8.kubernetes.api.model.PodIPFluentImpl<io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<N>> implements io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PodIPsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodIP item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.PodIPBuilder(this, item);
    }
    PodIPsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.PodIPBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodIPBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodStatusFluentImpl.this.setToPodIPs(index,builder.build());
    }
    public N endPodIP() {
      return and();
    }
    
  }
  
}