package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PodSecurityContextBuilder extends io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl<io.fabric8.kubernetes.api.model.PodSecurityContextBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.PodSecurityContext,io.fabric8.kubernetes.api.model.PodSecurityContextBuilder>{
  public PodSecurityContextBuilder() {
    this(false);
  }
  public PodSecurityContextBuilder(java.lang.Boolean validationEnabled) {
    this(new PodSecurityContext(), validationEnabled);
  }
  public PodSecurityContextBuilder(io.fabric8.kubernetes.api.model.PodSecurityContextFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityContextBuilder(io.fabric8.kubernetes.api.model.PodSecurityContextFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodSecurityContext(), validationEnabled);
  }
  public PodSecurityContextBuilder(io.fabric8.kubernetes.api.model.PodSecurityContextFluent<?> fluent,io.fabric8.kubernetes.api.model.PodSecurityContext instance) {
    this(fluent, instance, false);
  }
  public PodSecurityContextBuilder(io.fabric8.kubernetes.api.model.PodSecurityContextFluent<?> fluent,io.fabric8.kubernetes.api.model.PodSecurityContext instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsGroup(instance.getFsGroup()); 
    fluent.withFsGroupChangePolicy(instance.getFsGroupChangePolicy()); 
    fluent.withRunAsGroup(instance.getRunAsGroup()); 
    fluent.withRunAsNonRoot(instance.getRunAsNonRoot()); 
    fluent.withRunAsUser(instance.getRunAsUser()); 
    fluent.withSeLinuxOptions(instance.getSeLinuxOptions()); 
    fluent.withSeccompProfile(instance.getSeccompProfile()); 
    fluent.withSupplementalGroups(instance.getSupplementalGroups()); 
    fluent.withSysctls(instance.getSysctls()); 
    fluent.withWindowsOptions(instance.getWindowsOptions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityContextBuilder(io.fabric8.kubernetes.api.model.PodSecurityContext instance) {
    this(instance,false);
  }
  public PodSecurityContextBuilder(io.fabric8.kubernetes.api.model.PodSecurityContext instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsGroup(instance.getFsGroup()); 
    this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy()); 
    this.withRunAsGroup(instance.getRunAsGroup()); 
    this.withRunAsNonRoot(instance.getRunAsNonRoot()); 
    this.withRunAsUser(instance.getRunAsUser()); 
    this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
    this.withSeccompProfile(instance.getSeccompProfile()); 
    this.withSupplementalGroups(instance.getSupplementalGroups()); 
    this.withSysctls(instance.getSysctls()); 
    this.withWindowsOptions(instance.getWindowsOptions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodSecurityContextFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodSecurityContext build() {
    PodSecurityContext buildable = new PodSecurityContext(fluent.getFsGroup(),fluent.getFsGroupChangePolicy(),fluent.getRunAsGroup(),fluent.getRunAsNonRoot(),fluent.getRunAsUser(),fluent.getSeLinuxOptions(),fluent.getSeccompProfile(),fluent.getSupplementalGroups(),fluent.getSysctls(),fluent.getWindowsOptions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodSecurityContextBuilder that = (PodSecurityContextBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}