package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NodeConfigStatusBuilder extends io.fabric8.kubernetes.api.model.NodeConfigStatusFluentImpl<io.fabric8.kubernetes.api.model.NodeConfigStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NodeConfigStatus,io.fabric8.kubernetes.api.model.NodeConfigStatusBuilder>{
  public NodeConfigStatusBuilder() {
    this(false);
  }
  public NodeConfigStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new NodeConfigStatus(), validationEnabled);
  }
  public NodeConfigStatusBuilder(io.fabric8.kubernetes.api.model.NodeConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeConfigStatusBuilder(io.fabric8.kubernetes.api.model.NodeConfigStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeConfigStatus(), validationEnabled);
  }
  public NodeConfigStatusBuilder(io.fabric8.kubernetes.api.model.NodeConfigStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeConfigStatus instance) {
    this(fluent, instance, false);
  }
  public NodeConfigStatusBuilder(io.fabric8.kubernetes.api.model.NodeConfigStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeConfigStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withActive(instance.getActive()); 
    fluent.withAssigned(instance.getAssigned()); 
    fluent.withError(instance.getError()); 
    fluent.withLastKnownGood(instance.getLastKnownGood()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeConfigStatusBuilder(io.fabric8.kubernetes.api.model.NodeConfigStatus instance) {
    this(instance,false);
  }
  public NodeConfigStatusBuilder(io.fabric8.kubernetes.api.model.NodeConfigStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withActive(instance.getActive()); 
    this.withAssigned(instance.getAssigned()); 
    this.withError(instance.getError()); 
    this.withLastKnownGood(instance.getLastKnownGood()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeConfigStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeConfigStatus build() {
    NodeConfigStatus buildable = new NodeConfigStatus(fluent.getActive(),fluent.getAssigned(),fluent.getError(),fluent.getLastKnownGood());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeConfigStatusBuilder that = (NodeConfigStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}