package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class GroupVersionForDiscoveryBuilder extends io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluentImpl<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery,io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder>{
  public GroupVersionForDiscoveryBuilder() {
    this(false);
  }
  public GroupVersionForDiscoveryBuilder(java.lang.Boolean validationEnabled) {
    this(new GroupVersionForDiscovery(), validationEnabled);
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GroupVersionForDiscovery(), validationEnabled);
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery instance) {
    this(fluent, instance, false);
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroupVersion(instance.getGroupVersion()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery instance) {
    this(instance,false);
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroupVersion(instance.getGroupVersion()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery build() {
    GroupVersionForDiscovery buildable = new GroupVersionForDiscovery(fluent.getGroupVersion(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GroupVersionForDiscoveryBuilder that = (GroupVersionForDiscoveryBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}