package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ContainerImageBuilder extends io.fabric8.kubernetes.api.model.ContainerImageFluentImpl<io.fabric8.kubernetes.api.model.ContainerImageBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ContainerImage,io.fabric8.kubernetes.api.model.ContainerImageBuilder>{
  public ContainerImageBuilder() {
    this(false);
  }
  public ContainerImageBuilder(java.lang.Boolean validationEnabled) {
    this(new ContainerImage(), validationEnabled);
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerImage(), validationEnabled);
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerImage instance) {
    this(fluent, instance, false);
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerImage instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNames(instance.getNames()); 
    fluent.withSizeBytes(instance.getSizeBytes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImage instance) {
    this(instance,false);
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImage instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNames(instance.getNames()); 
    this.withSizeBytes(instance.getSizeBytes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ContainerImage build() {
    ContainerImage buildable = new ContainerImage(fluent.getNames(),fluent.getSizeBytes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerImageBuilder that = (ContainerImageBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}