package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ConfigMapBuilder extends io.fabric8.kubernetes.api.model.ConfigMapFluentImpl<io.fabric8.kubernetes.api.model.ConfigMapBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ConfigMap,io.fabric8.kubernetes.api.model.ConfigMapBuilder>{
  public ConfigMapBuilder() {
    this(false);
  }
  public ConfigMapBuilder(java.lang.Boolean validationEnabled) {
    this(new ConfigMap(), validationEnabled);
  }
  public ConfigMapBuilder(io.fabric8.kubernetes.api.model.ConfigMapFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapBuilder(io.fabric8.kubernetes.api.model.ConfigMapFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConfigMap(), validationEnabled);
  }
  public ConfigMapBuilder(io.fabric8.kubernetes.api.model.ConfigMapFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMap instance) {
    this(fluent, instance, false);
  }
  public ConfigMapBuilder(io.fabric8.kubernetes.api.model.ConfigMapFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMap instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withBinaryData(instance.getBinaryData()); 
    fluent.withData(instance.getData()); 
    fluent.withImmutable(instance.getImmutable()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapBuilder(io.fabric8.kubernetes.api.model.ConfigMap instance) {
    this(instance,false);
  }
  public ConfigMapBuilder(io.fabric8.kubernetes.api.model.ConfigMap instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withBinaryData(instance.getBinaryData()); 
    this.withData(instance.getData()); 
    this.withImmutable(instance.getImmutable()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ConfigMapFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ConfigMap build() {
    ConfigMap buildable = new ConfigMap(fluent.getApiVersion(),fluent.getBinaryData(),fluent.getData(),fluent.getImmutable(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConfigMapBuilder that = (ConfigMapBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}