package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class APIResourceBuilder extends io.fabric8.kubernetes.api.model.APIResourceFluentImpl<io.fabric8.kubernetes.api.model.APIResourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.APIResource,io.fabric8.kubernetes.api.model.APIResourceBuilder>{
  public APIResourceBuilder() {
    this(false);
  }
  public APIResourceBuilder(java.lang.Boolean validationEnabled) {
    this(new APIResource(), validationEnabled);
  }
  public APIResourceBuilder(io.fabric8.kubernetes.api.model.APIResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public APIResourceBuilder(io.fabric8.kubernetes.api.model.APIResourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIResource(), validationEnabled);
  }
  public APIResourceBuilder(io.fabric8.kubernetes.api.model.APIResourceFluent<?> fluent,io.fabric8.kubernetes.api.model.APIResource instance) {
    this(fluent, instance, false);
  }
  public APIResourceBuilder(io.fabric8.kubernetes.api.model.APIResourceFluent<?> fluent,io.fabric8.kubernetes.api.model.APIResource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCategories(instance.getCategories()); 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespaced(instance.getNamespaced()); 
    fluent.withShortNames(instance.getShortNames()); 
    fluent.withSingularName(instance.getSingularName()); 
    fluent.withStorageVersionHash(instance.getStorageVersionHash()); 
    fluent.withVerbs(instance.getVerbs()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIResourceBuilder(io.fabric8.kubernetes.api.model.APIResource instance) {
    this(instance,false);
  }
  public APIResourceBuilder(io.fabric8.kubernetes.api.model.APIResource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCategories(instance.getCategories()); 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespaced(instance.getNamespaced()); 
    this.withShortNames(instance.getShortNames()); 
    this.withSingularName(instance.getSingularName()); 
    this.withStorageVersionHash(instance.getStorageVersionHash()); 
    this.withVerbs(instance.getVerbs()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.APIResourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.APIResource build() {
    APIResource buildable = new APIResource(fluent.getCategories(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespaced(),fluent.getShortNames(),fluent.getSingularName(),fluent.getStorageVersionHash(),fluent.getVerbs(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIResourceBuilder that = (APIResourceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}