package io.fabric8.kubernetes.api.model.coordination.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LeaseCandidateSpecFluent<A extends LeaseCandidateSpecFluent<A>> extends BaseFluent<A>{
  public LeaseCandidateSpecFluent() {
  }
  
  public LeaseCandidateSpecFluent(LeaseCandidateSpec instance) {
    this.copyInstance(instance);
  }
  private String binaryVersion;
  private String emulationVersion;
  private String leaseName;
  private MicroTime pingTime;
  private MicroTime renewTime;
  private String strategy;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(LeaseCandidateSpec instance) {
    instance = (instance != null ? instance : new LeaseCandidateSpec());
    if (instance != null) {
          this.withBinaryVersion(instance.getBinaryVersion());
          this.withEmulationVersion(instance.getEmulationVersion());
          this.withLeaseName(instance.getLeaseName());
          this.withPingTime(instance.getPingTime());
          this.withRenewTime(instance.getRenewTime());
          this.withStrategy(instance.getStrategy());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBinaryVersion() {
    return this.binaryVersion;
  }
  
  public A withBinaryVersion(String binaryVersion) {
    this.binaryVersion = binaryVersion;
    return (A) this;
  }
  
  public boolean hasBinaryVersion() {
    return this.binaryVersion != null;
  }
  
  public String getEmulationVersion() {
    return this.emulationVersion;
  }
  
  public A withEmulationVersion(String emulationVersion) {
    this.emulationVersion = emulationVersion;
    return (A) this;
  }
  
  public boolean hasEmulationVersion() {
    return this.emulationVersion != null;
  }
  
  public String getLeaseName() {
    return this.leaseName;
  }
  
  public A withLeaseName(String leaseName) {
    this.leaseName = leaseName;
    return (A) this;
  }
  
  public boolean hasLeaseName() {
    return this.leaseName != null;
  }
  
  public MicroTime getPingTime() {
    return this.pingTime;
  }
  
  public A withPingTime(MicroTime pingTime) {
    this.pingTime = pingTime;
    return (A) this;
  }
  
  public boolean hasPingTime() {
    return this.pingTime != null;
  }
  
  public A withNewPingTime(String time) {
    return (A)withPingTime(new MicroTime(time));
  }
  
  public MicroTime getRenewTime() {
    return this.renewTime;
  }
  
  public A withRenewTime(MicroTime renewTime) {
    this.renewTime = renewTime;
    return (A) this;
  }
  
  public boolean hasRenewTime() {
    return this.renewTime != null;
  }
  
  public A withNewRenewTime(String time) {
    return (A)withRenewTime(new MicroTime(time));
  }
  
  public String getStrategy() {
    return this.strategy;
  }
  
  public A withStrategy(String strategy) {
    this.strategy = strategy;
    return (A) this;
  }
  
  public boolean hasStrategy() {
    return this.strategy != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LeaseCandidateSpecFluent that = (LeaseCandidateSpecFluent) o;
    if (!java.util.Objects.equals(binaryVersion, that.binaryVersion)) return false;
    if (!java.util.Objects.equals(emulationVersion, that.emulationVersion)) return false;
    if (!java.util.Objects.equals(leaseName, that.leaseName)) return false;
    if (!java.util.Objects.equals(pingTime, that.pingTime)) return false;
    if (!java.util.Objects.equals(renewTime, that.renewTime)) return false;
    if (!java.util.Objects.equals(strategy, that.strategy)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(binaryVersion,  emulationVersion,  leaseName,  pingTime,  renewTime,  strategy,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (binaryVersion != null) { sb.append("binaryVersion:"); sb.append(binaryVersion + ","); }
    if (emulationVersion != null) { sb.append("emulationVersion:"); sb.append(emulationVersion + ","); }
    if (leaseName != null) { sb.append("leaseName:"); sb.append(leaseName + ","); }
    if (pingTime != null) { sb.append("pingTime:"); sb.append(pingTime + ","); }
    if (renewTime != null) { sb.append("renewTime:"); sb.append(renewTime + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}