package io.fabric8.kubernetes.api.model.coordination.v1;

import java.lang.Integer;
import java.time.ZonedDateTime;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class LeaseSpecFluentImpl<A extends LeaseSpecFluent<A>> extends BaseFluent<A> implements LeaseSpecFluent<A>{
  public LeaseSpecFluentImpl() {
  }
  public LeaseSpecFluentImpl(LeaseSpec instance) {
    this.withAcquireTime(instance.getAcquireTime()); 
    this.withHolderIdentity(instance.getHolderIdentity()); 
    this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds()); 
    this.withLeaseTransitions(instance.getLeaseTransitions()); 
    this.withRenewTime(instance.getRenewTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ZonedDateTime acquireTime;
  private String holderIdentity;
  private Integer leaseDurationSeconds;
  private Integer leaseTransitions;
  private ZonedDateTime renewTime;
  private Map<String,Object> additionalProperties;
  public ZonedDateTime getAcquireTime() {
    return this.acquireTime;
  }
  public A withAcquireTime(ZonedDateTime acquireTime) {
    this.acquireTime=acquireTime; return (A) this;
  }
  public Boolean hasAcquireTime() {
    return this.acquireTime != null;
  }
  public String getHolderIdentity() {
    return this.holderIdentity;
  }
  public A withHolderIdentity(String holderIdentity) {
    this.holderIdentity=holderIdentity; return (A) this;
  }
  public Boolean hasHolderIdentity() {
    return this.holderIdentity != null;
  }
  public Integer getLeaseDurationSeconds() {
    return this.leaseDurationSeconds;
  }
  public A withLeaseDurationSeconds(Integer leaseDurationSeconds) {
    this.leaseDurationSeconds=leaseDurationSeconds; return (A) this;
  }
  public Boolean hasLeaseDurationSeconds() {
    return this.leaseDurationSeconds != null;
  }
  public Integer getLeaseTransitions() {
    return this.leaseTransitions;
  }
  public A withLeaseTransitions(Integer leaseTransitions) {
    this.leaseTransitions=leaseTransitions; return (A) this;
  }
  public Boolean hasLeaseTransitions() {
    return this.leaseTransitions != null;
  }
  public ZonedDateTime getRenewTime() {
    return this.renewTime;
  }
  public A withRenewTime(ZonedDateTime renewTime) {
    this.renewTime=renewTime; return (A) this;
  }
  public Boolean hasRenewTime() {
    return this.renewTime != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LeaseSpecFluentImpl that = (LeaseSpecFluentImpl) o;
    if (acquireTime != null ? !acquireTime.equals(that.acquireTime) :that.acquireTime != null) return false;
    if (holderIdentity != null ? !holderIdentity.equals(that.holderIdentity) :that.holderIdentity != null) return false;
    if (leaseDurationSeconds != null ? !leaseDurationSeconds.equals(that.leaseDurationSeconds) :that.leaseDurationSeconds != null) return false;
    if (leaseTransitions != null ? !leaseTransitions.equals(that.leaseTransitions) :that.leaseTransitions != null) return false;
    if (renewTime != null ? !renewTime.equals(that.renewTime) :that.renewTime != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(acquireTime,  holderIdentity,  leaseDurationSeconds,  leaseTransitions,  renewTime,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (acquireTime != null) { sb.append("acquireTime:"); sb.append(acquireTime + ","); }
    if (holderIdentity != null) { sb.append("holderIdentity:"); sb.append(holderIdentity + ","); }
    if (leaseDurationSeconds != null) { sb.append("leaseDurationSeconds:"); sb.append(leaseDurationSeconds + ","); }
    if (leaseTransitions != null) { sb.append("leaseTransitions:"); sb.append(leaseTransitions + ","); }
    if (renewTime != null) { sb.append("renewTime:"); sb.append(renewTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}