package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class LeaseSpecBuilder extends io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecFluentImpl<io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec,io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecBuilder>{
  public LeaseSpecBuilder() {
    this(false);
  }
  public LeaseSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new LeaseSpec(), validationEnabled);
  }
  public LeaseSpecBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public LeaseSpecBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LeaseSpec(), validationEnabled);
  }
  public LeaseSpecBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec instance) {
    this(fluent, instance, false);
  }
  public LeaseSpecBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAcquireTime(instance.getAcquireTime()); 
    fluent.withHolderIdentity(instance.getHolderIdentity()); 
    fluent.withLeaseDurationSeconds(instance.getLeaseDurationSeconds()); 
    fluent.withLeaseTransitions(instance.getLeaseTransitions()); 
    fluent.withRenewTime(instance.getRenewTime()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LeaseSpecBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec instance) {
    this(instance,false);
  }
  public LeaseSpecBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAcquireTime(instance.getAcquireTime()); 
    this.withHolderIdentity(instance.getHolderIdentity()); 
    this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds()); 
    this.withLeaseTransitions(instance.getLeaseTransitions()); 
    this.withRenewTime(instance.getRenewTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec build() {
    LeaseSpec buildable = new LeaseSpec(fluent.getAcquireTime(),fluent.getHolderIdentity(),fluent.getLeaseDurationSeconds(),fluent.getLeaseTransitions(),fluent.getRenewTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LeaseSpecBuilder that = (LeaseSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}