package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodFailurePolicyRuleBuilder extends PodFailurePolicyRuleFluentImpl<PodFailurePolicyRuleBuilder> implements VisitableBuilder<PodFailurePolicyRule,PodFailurePolicyRuleBuilder>{
  public PodFailurePolicyRuleBuilder() {
    this(false);
  }
  public PodFailurePolicyRuleBuilder(Boolean validationEnabled) {
    this(new PodFailurePolicyRule(), validationEnabled);
  }
  public PodFailurePolicyRuleBuilder(PodFailurePolicyRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public PodFailurePolicyRuleBuilder(PodFailurePolicyRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodFailurePolicyRule(), validationEnabled);
  }
  public PodFailurePolicyRuleBuilder(PodFailurePolicyRuleFluent<?> fluent,PodFailurePolicyRule instance) {
    this(fluent, instance, false);
  }
  public PodFailurePolicyRuleBuilder(PodFailurePolicyRuleFluent<?> fluent,PodFailurePolicyRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAction(instance.getAction()); 
    fluent.withOnExitCodes(instance.getOnExitCodes()); 
    fluent.withOnPodConditions(instance.getOnPodConditions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodFailurePolicyRuleBuilder(PodFailurePolicyRule instance) {
    this(instance,false);
  }
  public PodFailurePolicyRuleBuilder(PodFailurePolicyRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAction(instance.getAction()); 
    this.withOnExitCodes(instance.getOnExitCodes()); 
    this.withOnPodConditions(instance.getOnPodConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodFailurePolicyRuleFluent<?> fluent;
  Boolean validationEnabled;
  public PodFailurePolicyRule build() {
    PodFailurePolicyRule buildable = new PodFailurePolicyRule(fluent.getAction(),fluent.getOnExitCodes(),fluent.getOnPodConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}