package io.fabric8.kubernetes.api.model.batch.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CronJobSpecFluentImpl<A extends CronJobSpecFluent<A>> extends BaseFluent<A> implements CronJobSpecFluent<A>{
  public CronJobSpecFluentImpl() {
  }
  public CronJobSpecFluentImpl(CronJobSpec instance) {
    this.withConcurrencyPolicy(instance.getConcurrencyPolicy()); 
    this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit()); 
    this.withJobTemplate(instance.getJobTemplate()); 
    this.withSchedule(instance.getSchedule()); 
    this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds()); 
    this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit()); 
    this.withSuspend(instance.getSuspend()); 
    this.withTimeZone(instance.getTimeZone()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String concurrencyPolicy;
  private Integer failedJobsHistoryLimit;
  private JobTemplateSpecBuilder jobTemplate;
  private String schedule;
  private Long startingDeadlineSeconds;
  private Integer successfulJobsHistoryLimit;
  private Boolean suspend;
  private String timeZone;
  private Map<String,Object> additionalProperties;
  public String getConcurrencyPolicy() {
    return this.concurrencyPolicy;
  }
  public A withConcurrencyPolicy(String concurrencyPolicy) {
    this.concurrencyPolicy=concurrencyPolicy; return (A) this;
  }
  public Boolean hasConcurrencyPolicy() {
    return this.concurrencyPolicy != null;
  }
  public Integer getFailedJobsHistoryLimit() {
    return this.failedJobsHistoryLimit;
  }
  public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
    this.failedJobsHistoryLimit=failedJobsHistoryLimit; return (A) this;
  }
  public Boolean hasFailedJobsHistoryLimit() {
    return this.failedJobsHistoryLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildJobTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public JobTemplateSpec getJobTemplate() {
    return this.jobTemplate!=null ?this.jobTemplate.build():null;
  }
  public JobTemplateSpec buildJobTemplate() {
    return this.jobTemplate!=null ?this.jobTemplate.build():null;
  }
  public A withJobTemplate(JobTemplateSpec jobTemplate) {
    _visitables.get("jobTemplate").remove(this.jobTemplate);
    if (jobTemplate!=null){ this.jobTemplate= new JobTemplateSpecBuilder(jobTemplate); _visitables.get("jobTemplate").add(this.jobTemplate);} else { this.jobTemplate = null; _visitables.get("jobTemplate").remove(this.jobTemplate); } return (A) this;
  }
  public Boolean hasJobTemplate() {
    return this.jobTemplate != null;
  }
  public CronJobSpecFluent.JobTemplateNested<A> withNewJobTemplate() {
    return new CronJobSpecFluentImpl.JobTemplateNestedImpl();
  }
  public CronJobSpecFluent.JobTemplateNested<A> withNewJobTemplateLike(JobTemplateSpec item) {
    return new CronJobSpecFluentImpl.JobTemplateNestedImpl(item);
  }
  public CronJobSpecFluent.JobTemplateNested<A> editJobTemplate() {
    return withNewJobTemplateLike(getJobTemplate());
  }
  public CronJobSpecFluent.JobTemplateNested<A> editOrNewJobTemplate() {
    return withNewJobTemplateLike(getJobTemplate() != null ? getJobTemplate(): new JobTemplateSpecBuilder().build());
  }
  public CronJobSpecFluent.JobTemplateNested<A> editOrNewJobTemplateLike(JobTemplateSpec item) {
    return withNewJobTemplateLike(getJobTemplate() != null ? getJobTemplate(): item);
  }
  public String getSchedule() {
    return this.schedule;
  }
  public A withSchedule(String schedule) {
    this.schedule=schedule; return (A) this;
  }
  public Boolean hasSchedule() {
    return this.schedule != null;
  }
  public Long getStartingDeadlineSeconds() {
    return this.startingDeadlineSeconds;
  }
  public A withStartingDeadlineSeconds(Long startingDeadlineSeconds) {
    this.startingDeadlineSeconds=startingDeadlineSeconds; return (A) this;
  }
  public Boolean hasStartingDeadlineSeconds() {
    return this.startingDeadlineSeconds != null;
  }
  public Integer getSuccessfulJobsHistoryLimit() {
    return this.successfulJobsHistoryLimit;
  }
  public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
    this.successfulJobsHistoryLimit=successfulJobsHistoryLimit; return (A) this;
  }
  public Boolean hasSuccessfulJobsHistoryLimit() {
    return this.successfulJobsHistoryLimit != null;
  }
  public Boolean getSuspend() {
    return this.suspend;
  }
  public A withSuspend(Boolean suspend) {
    this.suspend=suspend; return (A) this;
  }
  public Boolean hasSuspend() {
    return this.suspend != null;
  }
  public String getTimeZone() {
    return this.timeZone;
  }
  public A withTimeZone(String timeZone) {
    this.timeZone=timeZone; return (A) this;
  }
  public Boolean hasTimeZone() {
    return this.timeZone != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CronJobSpecFluentImpl that = (CronJobSpecFluentImpl) o;
    if (concurrencyPolicy != null ? !concurrencyPolicy.equals(that.concurrencyPolicy) :that.concurrencyPolicy != null) return false;
    if (failedJobsHistoryLimit != null ? !failedJobsHistoryLimit.equals(that.failedJobsHistoryLimit) :that.failedJobsHistoryLimit != null) return false;
    if (jobTemplate != null ? !jobTemplate.equals(that.jobTemplate) :that.jobTemplate != null) return false;
    if (schedule != null ? !schedule.equals(that.schedule) :that.schedule != null) return false;
    if (startingDeadlineSeconds != null ? !startingDeadlineSeconds.equals(that.startingDeadlineSeconds) :that.startingDeadlineSeconds != null) return false;
    if (successfulJobsHistoryLimit != null ? !successfulJobsHistoryLimit.equals(that.successfulJobsHistoryLimit) :that.successfulJobsHistoryLimit != null) return false;
    if (suspend != null ? !suspend.equals(that.suspend) :that.suspend != null) return false;
    if (timeZone != null ? !timeZone.equals(that.timeZone) :that.timeZone != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(concurrencyPolicy,  failedJobsHistoryLimit,  jobTemplate,  schedule,  startingDeadlineSeconds,  successfulJobsHistoryLimit,  suspend,  timeZone,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (concurrencyPolicy != null) { sb.append("concurrencyPolicy:"); sb.append(concurrencyPolicy + ","); }
    if (failedJobsHistoryLimit != null) { sb.append("failedJobsHistoryLimit:"); sb.append(failedJobsHistoryLimit + ","); }
    if (jobTemplate != null) { sb.append("jobTemplate:"); sb.append(jobTemplate + ","); }
    if (schedule != null) { sb.append("schedule:"); sb.append(schedule + ","); }
    if (startingDeadlineSeconds != null) { sb.append("startingDeadlineSeconds:"); sb.append(startingDeadlineSeconds + ","); }
    if (successfulJobsHistoryLimit != null) { sb.append("successfulJobsHistoryLimit:"); sb.append(successfulJobsHistoryLimit + ","); }
    if (suspend != null) { sb.append("suspend:"); sb.append(suspend + ","); }
    if (timeZone != null) { sb.append("timeZone:"); sb.append(timeZone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withSuspend() {
    return withSuspend(true);
  }
  class JobTemplateNestedImpl<N> extends JobTemplateSpecFluentImpl<CronJobSpecFluent.JobTemplateNested<N>> implements CronJobSpecFluent.JobTemplateNested<N>,Nested<N>{
    JobTemplateNestedImpl(JobTemplateSpec item) {
      this.builder = new JobTemplateSpecBuilder(this, item);
    }
    JobTemplateNestedImpl() {
      this.builder = new JobTemplateSpecBuilder(this);
    }
    JobTemplateSpecBuilder builder;
    public N and() {
      return (N) CronJobSpecFluentImpl.this.withJobTemplate(builder.build());
    }
    public N endJobTemplate() {
      return and();
    }
    
  }
  
}