package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ScaleBuilder extends ScaleFluent<ScaleBuilder> implements VisitableBuilder<Scale,ScaleBuilder>{
  public ScaleBuilder() {
    this(new Scale());
  }
  
  public ScaleBuilder(ScaleFluent<?> fluent) {
    this(fluent, new Scale());
  }
  
  public ScaleBuilder(ScaleFluent<?> fluent,Scale instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ScaleBuilder(Scale instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ScaleFluent<?> fluent;
  
  public Scale build() {
    Scale buildable = new Scale(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}