package io.fabric8.kubernetes.api.model.autoscaling.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HorizontalPodAutoscalerSpecFluent<A extends HorizontalPodAutoscalerSpecFluent<A>> extends BaseFluent<A>{
  public HorizontalPodAutoscalerSpecFluent() {
  }
  
  public HorizontalPodAutoscalerSpecFluent(HorizontalPodAutoscalerSpec instance) {
    this.copyInstance(instance);
  }
  private Integer maxReplicas;
  private Integer minReplicas;
  private CrossVersionObjectReferenceBuilder scaleTargetRef;
  private Integer targetCPUUtilizationPercentage;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HorizontalPodAutoscalerSpec instance) {
    instance = (instance != null ? instance : new HorizontalPodAutoscalerSpec());
  
    if (instance != null) {
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleTargetRef(instance.getScaleTargetRef());
        this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleTargetRef(instance.getScaleTargetRef());
        this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public Integer getMaxReplicas() {
    return this.maxReplicas;
  }
  
  public A withMaxReplicas(Integer maxReplicas) {
    this.maxReplicas=maxReplicas; return (A) this;
  }
  
  public boolean hasMaxReplicas() {
    return this.maxReplicas != null;
  }
  
  public Integer getMinReplicas() {
    return this.minReplicas;
  }
  
  public A withMinReplicas(Integer minReplicas) {
    this.minReplicas=minReplicas; return (A) this;
  }
  
  public boolean hasMinReplicas() {
    return this.minReplicas != null;
  }
  
  public CrossVersionObjectReference buildScaleTargetRef() {
    return this.scaleTargetRef!=null ?this.scaleTargetRef.build():null;
  }
  
  public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
    _visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
    if (scaleTargetRef!=null){ this.scaleTargetRef= new CrossVersionObjectReferenceBuilder(scaleTargetRef); _visitables.get("scaleTargetRef").add(this.scaleTargetRef);} else { this.scaleTargetRef = null; _visitables.get("scaleTargetRef").remove(this.scaleTargetRef); } return (A) this;
  }
  
  public boolean hasScaleTargetRef() {
    return this.scaleTargetRef != null;
  }
  
  public A withNewScaleTargetRef(String apiVersion,String kind,String name) {
    return (A)withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  
  public ScaleTargetRefNested<A> withNewScaleTargetRef() {
    return new ScaleTargetRefNested(null);
  }
  
  public ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item) {
    return new ScaleTargetRefNested(item);
  }
  
  public ScaleTargetRefNested<A> editScaleTargetRef() {
    return withNewScaleTargetRefLike(java.util.Optional.ofNullable(buildScaleTargetRef()).orElse(null));
  }
  
  public ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
    return withNewScaleTargetRefLike(java.util.Optional.ofNullable(buildScaleTargetRef()).orElse(new CrossVersionObjectReferenceBuilder().build()));
  }
  
  public ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item) {
    return withNewScaleTargetRefLike(java.util.Optional.ofNullable(buildScaleTargetRef()).orElse(item));
  }
  
  public Integer getTargetCPUUtilizationPercentage() {
    return this.targetCPUUtilizationPercentage;
  }
  
  public A withTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
    this.targetCPUUtilizationPercentage=targetCPUUtilizationPercentage; return (A) this;
  }
  
  public boolean hasTargetCPUUtilizationPercentage() {
    return this.targetCPUUtilizationPercentage != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HorizontalPodAutoscalerSpecFluent that = (HorizontalPodAutoscalerSpecFluent) o;
    if (!java.util.Objects.equals(maxReplicas, that.maxReplicas)) return false;
  
    if (!java.util.Objects.equals(minReplicas, that.minReplicas)) return false;
  
    if (!java.util.Objects.equals(scaleTargetRef, that.scaleTargetRef)) return false;
  
    if (!java.util.Objects.equals(targetCPUUtilizationPercentage, that.targetCPUUtilizationPercentage)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(maxReplicas,  minReplicas,  scaleTargetRef,  targetCPUUtilizationPercentage,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (maxReplicas != null) { sb.append("maxReplicas:"); sb.append(maxReplicas + ","); }
    if (minReplicas != null) { sb.append("minReplicas:"); sb.append(minReplicas + ","); }
    if (scaleTargetRef != null) { sb.append("scaleTargetRef:"); sb.append(scaleTargetRef + ","); }
    if (targetCPUUtilizationPercentage != null) { sb.append("targetCPUUtilizationPercentage:"); sb.append(targetCPUUtilizationPercentage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ScaleTargetRefNested<N> extends CrossVersionObjectReferenceFluent<ScaleTargetRefNested<N>> implements Nested<N>{
    ScaleTargetRefNested(CrossVersionObjectReference item) {
      this.builder = new CrossVersionObjectReferenceBuilder(this, item);
    }
    CrossVersionObjectReferenceBuilder builder;
    
    public N and() {
      return (N) HorizontalPodAutoscalerSpecFluent.this.withScaleTargetRef(builder.build());
    }
    
    public N endScaleTargetRef() {
      return and();
    }
    
  
  }

}