package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceMetricStatusBuilder extends ResourceMetricStatusFluent<ResourceMetricStatusBuilder> implements VisitableBuilder<ResourceMetricStatus,ResourceMetricStatusBuilder>{
  public ResourceMetricStatusBuilder() {
    this(false);
  }
  public ResourceMetricStatusBuilder(Boolean validationEnabled) {
    this(new ResourceMetricStatus(), validationEnabled);
  }
  public ResourceMetricStatusBuilder(ResourceMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceMetricStatusBuilder(ResourceMetricStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceMetricStatus(), validationEnabled);
  }
  public ResourceMetricStatusBuilder(ResourceMetricStatusFluent<?> fluent,ResourceMetricStatus instance) {
    this(fluent, instance, false);
  }
  public ResourceMetricStatusBuilder(ResourceMetricStatusFluent<?> fluent,ResourceMetricStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceMetricStatus());

    if (instance != null) {
      fluent.withCurrent(instance.getCurrent());
      fluent.withName(instance.getName());
      fluent.withCurrent(instance.getCurrent());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceMetricStatusBuilder(ResourceMetricStatus instance) {
    this(instance,false);
  }
  public ResourceMetricStatusBuilder(ResourceMetricStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceMetricStatus());

    if (instance != null) {
      this.withCurrent(instance.getCurrent());
      this.withName(instance.getName());
      this.withCurrent(instance.getCurrent());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceMetricStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceMetricStatus build() {
    ResourceMetricStatus buildable = new ResourceMetricStatus(fluent.buildCurrent(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}