package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerResourceMetricStatusBuilder extends ContainerResourceMetricStatusFluent<ContainerResourceMetricStatusBuilder> implements VisitableBuilder<ContainerResourceMetricStatus,ContainerResourceMetricStatusBuilder>{
  public ContainerResourceMetricStatusBuilder() {
    this(false);
  }
  public ContainerResourceMetricStatusBuilder(Boolean validationEnabled) {
    this(new ContainerResourceMetricStatus(), validationEnabled);
  }
  public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerResourceMetricStatus(), validationEnabled);
  }
  public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatusFluent<?> fluent,ContainerResourceMetricStatus instance) {
    this(fluent, instance, false);
  }
  public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatusFluent<?> fluent,ContainerResourceMetricStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerResourceMetricStatus());

    if (instance != null) {
      fluent.withContainer(instance.getContainer());
      fluent.withCurrent(instance.getCurrent());
      fluent.withName(instance.getName());
      fluent.withContainer(instance.getContainer());
      fluent.withCurrent(instance.getCurrent());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatus instance) {
    this(instance,false);
  }
  public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerResourceMetricStatus());

    if (instance != null) {
      this.withContainer(instance.getContainer());
      this.withCurrent(instance.getCurrent());
      this.withName(instance.getName());
      this.withContainer(instance.getContainer());
      this.withCurrent(instance.getCurrent());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerResourceMetricStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerResourceMetricStatus build() {
    ContainerResourceMetricStatus buildable = new ContainerResourceMetricStatus(fluent.getContainer(),fluent.buildCurrent(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}