package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricSpecBuilder extends MetricSpecFluent<MetricSpecBuilder> implements VisitableBuilder<MetricSpec,MetricSpecBuilder>{
  public MetricSpecBuilder() {
    this(false);
  }
  public MetricSpecBuilder(Boolean validationEnabled) {
    this(new MetricSpec(), validationEnabled);
  }
  public MetricSpecBuilder(MetricSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricSpecBuilder(MetricSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MetricSpec(), validationEnabled);
  }
  public MetricSpecBuilder(MetricSpecFluent<?> fluent,MetricSpec instance) {
    this(fluent, instance, false);
  }
  public MetricSpecBuilder(MetricSpecFluent<?> fluent,MetricSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MetricSpec());

    if (instance != null) {
      fluent.withContainerResource(instance.getContainerResource());
      fluent.withExternal(instance.getExternal());
      fluent.withObject(instance.getObject());
      fluent.withPods(instance.getPods());
      fluent.withResource(instance.getResource());
      fluent.withType(instance.getType());
      fluent.withContainerResource(instance.getContainerResource());
      fluent.withExternal(instance.getExternal());
      fluent.withObject(instance.getObject());
      fluent.withPods(instance.getPods());
      fluent.withResource(instance.getResource());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MetricSpecBuilder(MetricSpec instance) {
    this(instance,false);
  }
  public MetricSpecBuilder(MetricSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MetricSpec());

    if (instance != null) {
      this.withContainerResource(instance.getContainerResource());
      this.withExternal(instance.getExternal());
      this.withObject(instance.getObject());
      this.withPods(instance.getPods());
      this.withResource(instance.getResource());
      this.withType(instance.getType());
      this.withContainerResource(instance.getContainerResource());
      this.withExternal(instance.getExternal());
      this.withObject(instance.getObject());
      this.withPods(instance.getPods());
      this.withResource(instance.getResource());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MetricSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MetricSpec build() {
    MetricSpec buildable = new MetricSpec(fluent.buildContainerResource(),fluent.buildExternal(),fluent.buildObject(),fluent.buildPods(),fluent.buildResource(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}