package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodsMetricSourceBuilder extends PodsMetricSourceFluentImpl<PodsMetricSourceBuilder> implements VisitableBuilder<PodsMetricSource,PodsMetricSourceBuilder>{
  public PodsMetricSourceBuilder() {
    this(false);
  }
  public PodsMetricSourceBuilder(Boolean validationEnabled) {
    this(new PodsMetricSource(), validationEnabled);
  }
  public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodsMetricSource(), validationEnabled);
  }
  public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent,PodsMetricSource instance) {
    this(fluent, instance, false);
  }
  public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent,PodsMetricSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMetric(instance.getMetric()); 
    fluent.withTarget(instance.getTarget()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodsMetricSourceBuilder(PodsMetricSource instance) {
    this(instance,false);
  }
  public PodsMetricSourceBuilder(PodsMetricSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMetric(instance.getMetric()); 
    this.withTarget(instance.getTarget()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodsMetricSourceFluent<?> fluent;
  Boolean validationEnabled;
  public PodsMetricSource build() {
    PodsMetricSource buildable = new PodsMetricSource(fluent.getMetric(),fluent.getTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}