package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricTargetBuilder extends MetricTargetFluentImpl<MetricTargetBuilder> implements VisitableBuilder<MetricTarget,MetricTargetBuilder>{
  public MetricTargetBuilder() {
    this(false);
  }
  public MetricTargetBuilder(Boolean validationEnabled) {
    this(new MetricTarget(), validationEnabled);
  }
  public MetricTargetBuilder(MetricTargetFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricTargetBuilder(MetricTargetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MetricTarget(), validationEnabled);
  }
  public MetricTargetBuilder(MetricTargetFluent<?> fluent,MetricTarget instance) {
    this(fluent, instance, false);
  }
  public MetricTargetBuilder(MetricTargetFluent<?> fluent,MetricTarget instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAverageUtilization(instance.getAverageUtilization()); 
    fluent.withAverageValue(instance.getAverageValue()); 
    fluent.withType(instance.getType()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MetricTargetBuilder(MetricTarget instance) {
    this(instance,false);
  }
  public MetricTargetBuilder(MetricTarget instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAverageUtilization(instance.getAverageUtilization()); 
    this.withAverageValue(instance.getAverageValue()); 
    this.withType(instance.getType()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MetricTargetFluent<?> fluent;
  Boolean validationEnabled;
  public MetricTarget build() {
    MetricTarget buildable = new MetricTarget(fluent.getAverageUtilization(),fluent.getAverageValue(),fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}