package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ObjectMetricSourceFluentImpl<A extends ObjectMetricSourceFluent<A>> extends BaseFluent<A> implements ObjectMetricSourceFluent<A>{
  public ObjectMetricSourceFluentImpl() {
  }
  public ObjectMetricSourceFluentImpl(ObjectMetricSource instance) {
    this.withAverageValue(instance.getAverageValue()); 
    this.withMetricName(instance.getMetricName()); 
    this.withSelector(instance.getSelector()); 
    this.withTarget(instance.getTarget()); 
    this.withTargetValue(instance.getTargetValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Quantity averageValue;
  private String metricName;
  private LabelSelectorBuilder selector;
  private CrossVersionObjectReferenceBuilder target;
  private Quantity targetValue;
  private Map<String,Object> additionalProperties;
  public Quantity getAverageValue() {
    return this.averageValue;
  }
  public A withAverageValue(Quantity averageValue) {
    this.averageValue=averageValue; return (A) this;
  }
  public Boolean hasAverageValue() {
    return this.averageValue != null;
  }
  public A withNewAverageValue(String amount,String format) {
    return (A)withAverageValue(new Quantity(amount, format));
  }
  public A withNewAverageValue(String amount) {
    return (A)withAverageValue(new Quantity(amount));
  }
  public String getMetricName() {
    return this.metricName;
  }
  public A withMetricName(String metricName) {
    this.metricName=metricName; return (A) this;
  }
  public Boolean hasMetricName() {
    return this.metricName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public ObjectMetricSourceFluent.SelectorNested<A> withNewSelector() {
    return new ObjectMetricSourceFluentImpl.SelectorNestedImpl();
  }
  public ObjectMetricSourceFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new ObjectMetricSourceFluentImpl.SelectorNestedImpl(item);
  }
  public ObjectMetricSourceFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public ObjectMetricSourceFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public ObjectMetricSourceFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTarget instead.
   * @return The buildable object.
   */
  @Deprecated
  public CrossVersionObjectReference getTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public CrossVersionObjectReference buildTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public A withTarget(CrossVersionObjectReference target) {
    _visitables.get("target").remove(this.target);
    if (target!=null){ this.target= new CrossVersionObjectReferenceBuilder(target); _visitables.get("target").add(this.target);} else { this.target = null; _visitables.get("target").remove(this.target); } return (A) this;
  }
  public Boolean hasTarget() {
    return this.target != null;
  }
  public A withNewTarget(String apiVersion,String kind,String name) {
    return (A)withTarget(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  public ObjectMetricSourceFluent.TargetNested<A> withNewTarget() {
    return new ObjectMetricSourceFluentImpl.TargetNestedImpl();
  }
  public ObjectMetricSourceFluent.TargetNested<A> withNewTargetLike(CrossVersionObjectReference item) {
    return new ObjectMetricSourceFluentImpl.TargetNestedImpl(item);
  }
  public ObjectMetricSourceFluent.TargetNested<A> editTarget() {
    return withNewTargetLike(getTarget());
  }
  public ObjectMetricSourceFluent.TargetNested<A> editOrNewTarget() {
    return withNewTargetLike(getTarget() != null ? getTarget(): new CrossVersionObjectReferenceBuilder().build());
  }
  public ObjectMetricSourceFluent.TargetNested<A> editOrNewTargetLike(CrossVersionObjectReference item) {
    return withNewTargetLike(getTarget() != null ? getTarget(): item);
  }
  public Quantity getTargetValue() {
    return this.targetValue;
  }
  public A withTargetValue(Quantity targetValue) {
    this.targetValue=targetValue; return (A) this;
  }
  public Boolean hasTargetValue() {
    return this.targetValue != null;
  }
  public A withNewTargetValue(String amount,String format) {
    return (A)withTargetValue(new Quantity(amount, format));
  }
  public A withNewTargetValue(String amount) {
    return (A)withTargetValue(new Quantity(amount));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ObjectMetricSourceFluentImpl that = (ObjectMetricSourceFluentImpl) o;
    if (averageValue != null ? !averageValue.equals(that.averageValue) :that.averageValue != null) return false;
    if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (target != null ? !target.equals(that.target) :that.target != null) return false;
    if (targetValue != null ? !targetValue.equals(that.targetValue) :that.targetValue != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(averageValue,  metricName,  selector,  target,  targetValue,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (averageValue != null) { sb.append("averageValue:"); sb.append(averageValue + ","); }
    if (metricName != null) { sb.append("metricName:"); sb.append(metricName + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (targetValue != null) { sb.append("targetValue:"); sb.append(targetValue + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ObjectMetricSourceFluent.SelectorNested<N>> implements ObjectMetricSourceFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ObjectMetricSourceFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class TargetNestedImpl<N> extends CrossVersionObjectReferenceFluentImpl<ObjectMetricSourceFluent.TargetNested<N>> implements ObjectMetricSourceFluent.TargetNested<N>,Nested<N>{
    TargetNestedImpl(CrossVersionObjectReference item) {
      this.builder = new CrossVersionObjectReferenceBuilder(this, item);
    }
    TargetNestedImpl() {
      this.builder = new CrossVersionObjectReferenceBuilder(this);
    }
    CrossVersionObjectReferenceBuilder builder;
    public N and() {
      return (N) ObjectMetricSourceFluentImpl.this.withTarget(builder.build());
    }
    public N endTarget() {
      return and();
    }
    
  }
  
}