package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ScaleSpecBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecBuilder>{
  public ScaleSpecBuilder() {
    this(false);
  }
  public ScaleSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ScaleSpec(), validationEnabled);
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ScaleSpec(), validationEnabled);
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance) {
    this(fluent, instance, false);
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance) {
    this(instance,false);
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withReplicas(instance.getReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec build() {
    ScaleSpec buildable = new ScaleSpec(fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ScaleSpecBuilder that = (ScaleSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}