package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StatefulSetConditionBuilder extends StatefulSetConditionFluent<StatefulSetConditionBuilder> implements VisitableBuilder<StatefulSetCondition,StatefulSetConditionBuilder>{
  public StatefulSetConditionBuilder() {
    this(new StatefulSetCondition());
  }
  
  public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent) {
    this(fluent, new StatefulSetCondition());
  }
  
  public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent,StatefulSetCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StatefulSetConditionBuilder(StatefulSetCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StatefulSetConditionFluent<?> fluent;
  
  public StatefulSetCondition build() {
    StatefulSetCondition buildable = new StatefulSetCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}