package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetListBuilder extends ReplicaSetListFluentImpl<ReplicaSetListBuilder> implements VisitableBuilder<ReplicaSetList,ReplicaSetListBuilder>{
  public ReplicaSetListBuilder() {
    this(false);
  }
  public ReplicaSetListBuilder(Boolean validationEnabled) {
    this(new ReplicaSetList(), validationEnabled);
  }
  public ReplicaSetListBuilder(ReplicaSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetListBuilder(ReplicaSetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplicaSetList(), validationEnabled);
  }
  public ReplicaSetListBuilder(ReplicaSetListFluent<?> fluent,ReplicaSetList instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetListBuilder(ReplicaSetListFluent<?> fluent,ReplicaSetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetListBuilder(ReplicaSetList instance) {
    this(instance,false);
  }
  public ReplicaSetListBuilder(ReplicaSetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ReplicaSetListFluent<?> fluent;
  Boolean validationEnabled;
  public ReplicaSetList build() {
    ReplicaSetList buildable = new ReplicaSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}