package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class StatefulSetUpdateStrategyBuilder extends io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyFluentImpl<io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy,io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyBuilder>{
  public StatefulSetUpdateStrategyBuilder() {
    this(false);
  }
  public StatefulSetUpdateStrategyBuilder(java.lang.Boolean validationEnabled) {
    this(new StatefulSetUpdateStrategy(), validationEnabled);
  }
  public StatefulSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new StatefulSetUpdateStrategy(), validationEnabled);
  }
  public StatefulSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy instance) {
    this(fluent, instance, false);
  }
  public StatefulSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRollingUpdate(instance.getRollingUpdate()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy instance) {
    this(instance,false);
  }
  public StatefulSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRollingUpdate(instance.getRollingUpdate()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy build() {
    StatefulSetUpdateStrategy buildable = new StatefulSetUpdateStrategy(fluent.getRollingUpdate(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StatefulSetUpdateStrategyBuilder that = (StatefulSetUpdateStrategyBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}