package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class StatefulSetConditionBuilder extends io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluentImpl<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition,io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder>{
  public StatefulSetConditionBuilder() {
    this(false);
  }
  public StatefulSetConditionBuilder(java.lang.Boolean validationEnabled) {
    this(new StatefulSetCondition(), validationEnabled);
  }
  public StatefulSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new StatefulSetCondition(), validationEnabled);
  }
  public StatefulSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.StatefulSetCondition instance) {
    this(fluent, instance, false);
  }
  public StatefulSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.StatefulSetCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition instance) {
    this(instance,false);
  }
  public StatefulSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.StatefulSetCondition build() {
    StatefulSetCondition buildable = new StatefulSetCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StatefulSetConditionBuilder that = (StatefulSetConditionBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}