package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DeploymentSpecBuilder extends io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluentImpl<io.fabric8.kubernetes.api.model.apps.DeploymentSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apps.DeploymentSpec,io.fabric8.kubernetes.api.model.apps.DeploymentSpecBuilder>{
  public DeploymentSpecBuilder() {
    this(false);
  }
  public DeploymentSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new DeploymentSpec(), validationEnabled);
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentSpec(), validationEnabled);
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DeploymentSpec instance) {
    this(fluent, instance, false);
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DeploymentSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withStrategy(instance.getStrategy()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpec instance) {
    this(instance,false);
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withPaused(instance.getPaused()); 
    this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withStrategy(instance.getStrategy()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.DeploymentSpec build() {
    DeploymentSpec buildable = new DeploymentSpec(fluent.getMinReadySeconds(),fluent.getPaused(),fluent.getProgressDeadlineSeconds(),fluent.getReplicas(),fluent.getRevisionHistoryLimit(),fluent.getSelector(),fluent.getStrategy(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeploymentSpecBuilder that = (DeploymentSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}